/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.server.http.cypher.InvalidTransactionId;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionLifecycleException;

public interface TransactionRegistry {
    public long begin(TransactionHandle var1);

    public long release(long var1, TransactionHandle var3);

    public TransactionHandle acquire(long var1) throws TransactionLifecycleException;

    public void forget(long var1);

    public TransactionHandle terminate(long var1) throws TransactionLifecycleException;

    public void rollbackAllSuspendedTransactions();

    public void rollbackSuspendedTransactionsIdleSince(long var1);

    default public TransactionHandle acquire(long id, LoginContext requestingUser) throws TransactionLifecycleException {
        this.assertSameUser(id, this.getLoginContextForTransaction(id), requestingUser);
        return this.acquire(id);
    }

    default public TransactionHandle terminate(long id, LoginContext requestingUser) throws TransactionLifecycleException {
        this.assertSameUser(id, this.getLoginContextForTransaction(id), requestingUser);
        return this.terminate(id);
    }

    default public void assertSameUser(long id, LoginContext owningUser, LoginContext requestingUser) throws InvalidTransactionId {
        if (!owningUser.subject().authenticatedUser().equals(requestingUser.subject().authenticatedUser())) {
            throw InvalidTransactionId.transactionDoesNotExists(id);
        }
    }

    public LoginContext getLoginContextForTransaction(long var1) throws InvalidTransactionId;
}

