/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.management.JmxService;
import org.neo4j.server.rest.management.RootService;
import org.neo4j.server.rest.management.VersionAndEditionService;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.server.web.WebServer;

public class ManagementApiModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;

    public ManagementApiModule(WebServer webServer, Config config) {
        this.webServer = webServer;
        this.config = config;
    }

    @Override
    public void start() {
        String serverMountPoint = this.managementApiUri().toString();
        this.webServer.addJAXRSClasses(this.getClassNames(), serverMountPoint, null);
    }

    private List<String> getClassNames() {
        return Arrays.asList(JmxService.class.getName(), RootService.class.getName(), VersionAndEditionService.class.getName());
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.getClassNames(), this.managementApiUri().toString());
    }

    private URI managementApiUri() {
        return (URI)this.config.get(ServerInternalSettings.management_api_path);
    }
}

