/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.neo4j.server.security.auth.Credential;

public class User {
    private final String name;
    private final Credential credential;
    private final boolean passwordChangeRequired;

    public User(String name, Credential credential, boolean passwordChangeRequired) {
        this.name = name;
        this.credential = credential;
        this.passwordChangeRequired = passwordChangeRequired;
    }

    public String name() {
        return this.name;
    }

    public Credential credentials() {
        return this.credential;
    }

    public boolean passwordChangeRequired() {
        return this.passwordChangeRequired;
    }

    public Builder augment() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (this.passwordChangeRequired != user.passwordChangeRequired) {
            return false;
        }
        if (this.credential != null ? !this.credential.equals(user.credential) : user.credential != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(user.name) : user.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.credential != null ? this.credential.hashCode() : 0);
        result = 31 * result + (this.passwordChangeRequired ? 1 : 0);
        return result;
    }

    public String toString() {
        return "User{name='" + this.name + '\'' + ", credentials=" + this.credential + ", passwordChangeRequired=" + this.passwordChangeRequired + '}';
    }

    public static class Builder {
        private String name;
        private Credential credential = Credential.INACCESSIBLE;
        private boolean pwdChangeRequired;

        public Builder() {
        }

        public Builder(User base) {
            this.name = base.name;
            this.credential = base.credential;
            this.pwdChangeRequired = base.passwordChangeRequired;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCredentials(Credential creds) {
            this.credential = creds;
            return this;
        }

        public Builder withRequiredPasswordChange(boolean change) {
            this.pwdChangeRequired = change;
            return this;
        }

        public User build() {
            return new User(this.name, this.credential, this.pwdChangeRequired);
        }
    }
}

