/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.regex.Pattern;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.dbms.AuthorizationFilter;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.web.WebServer;

public class AuthorizationModule
implements ServerModule {
    private final WebServer webServer;
    private final Config config;
    private final AuthManager authManager;
    private final LogProvider logProvider;
    private final Pattern[] uriWhitelist;

    public AuthorizationModule(WebServer webServer, AuthManager authManager, LogProvider logProvider, Config config, Pattern[] uriWhitelist) {
        this.webServer = webServer;
        this.config = config;
        this.authManager = authManager;
        this.logProvider = logProvider;
        this.uriWhitelist = uriWhitelist;
    }

    @Override
    public void start() {
        if (((Boolean)this.config.get(ServerSettings.auth_enabled)).booleanValue()) {
            AuthorizationFilter authorizationFilter = new AuthorizationFilter(this.authManager, this.logProvider, this.uriWhitelist);
            this.webServer.addFilter(authorizationFilter, "/*");
        }
    }

    @Override
    public void stop() {
    }
}

