/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd.sampler;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.server.rrd.Sampleable;
import org.rrd4j.DsType;

public class MemoryUsedSampleable
implements Sampleable {
    private final ObjectName memoryName;

    public MemoryUsedSampleable() {
        try {
            this.memoryName = new ObjectName("java.lang:type=Memory");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return "memory_usage_percent";
    }

    @Override
    public double getValue() {
        CompositeDataSupport heapMemoryUsage = (CompositeDataSupport)JmxUtils.getAttribute((ObjectName)this.memoryName, (String)"HeapMemoryUsage");
        long used = (Long)heapMemoryUsage.get("used");
        long max = (Long)heapMemoryUsage.get("max");
        return Math.ceil(100.0 * (double)used / (double)max);
    }

    @Override
    public DsType getType() {
        return DsType.GAUGE;
    }
}

