/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Clock;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransactionTerminationHandle;
import org.neo4j.server.rest.transactional.error.InvalidConcurrentTransactionAccess;
import org.neo4j.server.rest.transactional.error.InvalidTransactionId;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;

public class TransactionHandleRegistry
implements TransactionRegistry {
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final ConcurrentHashMap<Long, TransactionMarker> registry = new ConcurrentHashMap(64);
    private final Clock clock;
    private final Log log;
    private final long timeoutMillis;

    public TransactionHandleRegistry(Clock clock, long timeoutMillis, LogProvider logProvider) {
        this.clock = clock;
        this.timeoutMillis = timeoutMillis;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public long begin(TransactionHandle handle) {
        long id = this.idGenerator.incrementAndGet();
        if (null == this.registry.putIfAbsent(id, new ActiveTransaction(handle))) {
            return id;
        }
        throw new IllegalStateException("Attempt to begin transaction for id that was already registered");
    }

    @Override
    public long release(long id, TransactionHandle transactionHandle) {
        TransactionMarker marker = this.registry.get(id);
        if (null == marker) {
            throw new IllegalStateException("Trying to suspend unregistered transaction");
        }
        if (marker.isSuspended()) {
            throw new IllegalStateException("Trying to suspend transaction that was already suspended");
        }
        SuspendedTransaction suspendedTx = new SuspendedTransaction(marker.getActiveTransaction(), transactionHandle);
        if (!this.registry.replace(id, marker, suspendedTx)) {
            throw new IllegalStateException("Trying to suspend transaction that has been concurrently suspended");
        }
        return this.computeNewExpiryTime(suspendedTx.getLastActiveTimestamp());
    }

    private long computeNewExpiryTime(long lastActiveTimestamp) {
        return lastActiveTimestamp + this.timeoutMillis;
    }

    @Override
    public TransactionHandle acquire(long id) throws TransactionLifecycleException {
        TransactionMarker marker = this.registry.get(id);
        if (null == marker) {
            throw new InvalidTransactionId();
        }
        SuspendedTransaction transaction = marker.getSuspendedTransaction();
        if (this.registry.replace(id, marker, marker.getActiveTransaction())) {
            return transaction.transactionHandle;
        }
        throw new InvalidConcurrentTransactionAccess();
    }

    @Override
    public void forget(long id) {
        TransactionMarker marker = this.registry.get(id);
        if (null == marker) {
            throw new IllegalStateException("Could not finish unregistered transaction");
        }
        if (marker.isSuspended()) {
            throw new IllegalStateException("Cannot finish suspended registered transaction");
        }
        if (!this.registry.remove(id, marker)) {
            throw new IllegalStateException("Trying to finish transaction that has been concurrently finished or suspended");
        }
    }

    @Override
    public TransactionHandle terminate(long id) throws TransactionLifecycleException {
        TransactionMarker marker = this.registry.get(id);
        if (null == marker) {
            throw new InvalidTransactionId();
        }
        TransactionTerminationHandle handle = marker.getActiveTransaction().getTerminationHandle();
        handle.terminate();
        try {
            return this.acquire(id);
        }
        catch (InvalidConcurrentTransactionAccess exception) {
            return null;
        }
    }

    @Override
    public void rollbackAllSuspendedTransactions() {
        this.rollbackSuspended((Predicate<TransactionMarker>)Predicates.alwaysTrue());
    }

    public void rollbackSuspendedTransactionsIdleSince(final long oldestLastActiveTime) {
        this.rollbackSuspended(new Predicate<TransactionMarker>(){

            public boolean test(TransactionMarker item) {
                try {
                    SuspendedTransaction transaction = item.getSuspendedTransaction();
                    return transaction.lastActiveTimestamp < oldestLastActiveTime;
                }
                catch (InvalidConcurrentTransactionAccess concurrentTransactionAccessError) {
                    throw new RuntimeException(concurrentTransactionAccessError);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackSuspended(Predicate<TransactionMarker> predicate) {
        HashSet<Long> candidateTransactionIdsToRollback = new HashSet<Long>();
        for (Map.Entry<Long, TransactionMarker> entry : this.registry.entrySet()) {
            TransactionMarker marker = entry.getValue();
            if (!marker.isSuspended() || !predicate.test((Object)marker)) continue;
            candidateTransactionIdsToRollback.add(entry.getKey());
        }
        Iterator<Map.Entry<Long, TransactionMarker>> i$ = candidateTransactionIdsToRollback.iterator();
        while (i$.hasNext()) {
            TransactionHandle handle;
            long id = (Long)((Object)i$.next());
            try {
                handle = this.acquire(id);
            }
            catch (TransactionLifecycleException invalidTransactionId) {
                continue;
            }
            try {
                handle.forceRollback();
                this.log.info(String.format("Transaction with id %d has been automatically rolled back.", id));
            }
            catch (Throwable e) {
                this.log.error(String.format("Transaction with id %d failed to roll back.", id), e);
            }
            finally {
                this.forget(id);
            }
        }
    }

    private class SuspendedTransaction
    extends TransactionMarker {
        final ActiveTransaction activeMarker;
        final TransactionHandle transactionHandle;
        final long lastActiveTimestamp;

        private SuspendedTransaction(ActiveTransaction activeMarker, TransactionHandle transactionHandle) {
            this.activeMarker = activeMarker;
            this.transactionHandle = transactionHandle;
            this.lastActiveTimestamp = TransactionHandleRegistry.this.clock.currentTimeMillis();
        }

        @Override
        ActiveTransaction getActiveTransaction() {
            return this.activeMarker;
        }

        @Override
        SuspendedTransaction getSuspendedTransaction() throws InvalidConcurrentTransactionAccess {
            return this;
        }

        @Override
        boolean isSuspended() {
            return true;
        }

        public long getLastActiveTimestamp() {
            return this.lastActiveTimestamp;
        }
    }

    private static class ActiveTransaction
    extends TransactionMarker {
        final TransactionTerminationHandle terminationHandle;

        private ActiveTransaction(TransactionTerminationHandle terminationHandle) {
            this.terminationHandle = terminationHandle;
        }

        TransactionTerminationHandle getTerminationHandle() {
            return this.terminationHandle;
        }

        @Override
        ActiveTransaction getActiveTransaction() {
            return this;
        }

        @Override
        SuspendedTransaction getSuspendedTransaction() throws InvalidConcurrentTransactionAccess {
            throw new InvalidConcurrentTransactionAccess();
        }

        @Override
        boolean isSuspended() {
            return false;
        }
    }

    private static abstract class TransactionMarker {
        private TransactionMarker() {
        }

        abstract ActiveTransaction getActiveTransaction();

        abstract SuspendedTransaction getSuspendedTransaction() throws InvalidConcurrentTransactionAccess;

        abstract boolean isSuspended();
    }
}

