/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.function.Function;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class IndexDefinitionRepresentation
extends MappingRepresentation {
    private final IndexDefinition indexDefinition;

    public IndexDefinitionRepresentation(IndexDefinition indexDefinition) {
        super(RepresentationType.INDEX_DEFINITION);
        this.indexDefinition = indexDefinition;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putString("label", this.indexDefinition.getLabel().name());
        Function<String, Representation> converter = new Function<String, Representation>(){

            public Representation apply(String propertyKey) {
                return ValueRepresentation.string((String)propertyKey);
            }
        };
        Iterable propertyKeyRepresentations = Iterables.map((Function)converter, (Iterable)this.indexDefinition.getPropertyKeys());
        serializer.putList("property_keys", new ListRepresentation(RepresentationType.STRING, propertyKeyRepresentations));
    }
}

