/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.logging.Logger;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.web.ServerInternalSettings;

@Deprecated
public interface Configurator {
    public static final String SECURITY_RULES_KEY = ServerSettings.security_rules.name();
    public static final String AUTH_STORE_FILE_KEY = ServerInternalSettings.auth_store.name();
    public static final String DB_TUNING_PROPERTY_FILE_KEY = ServerInternalSettings.legacy_db_config.name();
    public static final String DEFAULT_CONFIG_DIR = File.separator + "etc" + File.separator + "neo";
    public static final String DATABASE_LOCATION_PROPERTY_KEY = ServerInternalSettings.legacy_db_location.name();
    public static final String DEFAULT_DATABASE_LOCATION_PROPERTY_KEY = ServerInternalSettings.legacy_db_location.getDefaultValue();
    public static final String NEO_SERVER_CONFIG_FILE_KEY = "org.neo4j.server.properties";
    public static final String DB_MODE_KEY = "org.neo4j.server.database.mode";
    public static final int DEFAULT_WEBSERVER_PORT = Integer.valueOf(ServerSettings.webserver_port.getDefaultValue());
    public static final String WEBSERVER_PORT_PROPERTY_KEY = ServerSettings.webserver_port.name();
    public static final String DEFAULT_WEBSERVER_ADDRESS = ServerSettings.webserver_address.getDefaultValue();
    public static final String WEBSERVER_ADDRESS_PROPERTY_KEY = ServerSettings.webserver_address.name();
    public static final String WEBSERVER_MAX_THREADS_PROPERTY_KEY = ServerSettings.webserver_max_threads.name();
    public static final String WEBSERVER_LIMIT_EXECUTION_TIME_PROPERTY_KEY = ServerSettings.webserver_limit_execution_time.name();
    public static final String WEBSERVER_ENABLE_STATISTICS_COLLECTION = ServerInternalSettings.webserver_statistics_collection_enabled.name();
    public static final String REST_API_PACKAGE = "org.neo4j.server.rest.web";
    public static final String REST_API_PATH_PROPERTY_KEY = ServerInternalSettings.rest_api_path.name();
    public static final String DEFAULT_DATA_API_PATH = ServerInternalSettings.rest_api_path.getDefaultValue();
    public static final String DISCOVERY_API_PACKAGE = "org.neo4j.server.rest.discovery";
    public static final String MANAGEMENT_API_PACKAGE = "org.neo4j.server.webadmin.rest";
    public static final String MANAGEMENT_PATH_PROPERTY_KEY = ServerInternalSettings.management_api_path.name();
    public static final String DEFAULT_MANAGEMENT_API_PATH = ServerInternalSettings.management_api_path.getDefaultValue();
    public static final String BROWSER_PATH = ServerInternalSettings.browser_path.getDefaultValue();
    public static final String RRDB_LOCATION_PROPERTY_KEY = ServerSettings.rrdb_location.name();
    public static final String MANAGEMENT_CONSOLE_ENGINES = ServerSettings.management_console_engines.name();
    public static final List<String> DEFAULT_MANAGEMENT_CONSOLE_ENGINES = new ArrayList<String>(){
        private static final long serialVersionUID = 6621747998288594121L;
        {
            this.add(ServerSettings.management_console_engines.getDefaultValue());
        }
    };
    public static final String THIRD_PARTY_PACKAGES_KEY = ServerSettings.third_party_packages.name();
    public static final String SCRIPT_SANDBOXING_ENABLED_KEY = ServerInternalSettings.script_sandboxing_enabled.name();
    public static final Boolean DEFAULT_SCRIPT_SANDBOXING_ENABLED = Boolean.valueOf(ServerInternalSettings.script_sandboxing_enabled.getDefaultValue());
    public static final String WEBSERVER_HTTPS_ENABLED_PROPERTY_KEY = ServerSettings.webserver_https_enabled.name();
    public static final Boolean DEFAULT_WEBSERVER_HTTPS_ENABLED = Boolean.valueOf(ServerSettings.webserver_https_enabled.getDefaultValue());
    public static final String WEBSERVER_HTTPS_PORT_PROPERTY_KEY = ServerSettings.webserver_https_port.name();
    public static final int DEFAULT_WEBSERVER_HTTPS_PORT = Integer.valueOf(ServerSettings.webserver_https_port.getDefaultValue());
    public static final String WEBSERVER_KEYSTORE_PATH_PROPERTY_KEY = "org.neo4j.server.webserver.https.keystore.location";
    public static final String DEFAULT_WEBSERVER_KEYSTORE_PATH = "";
    public static final String WEBSERVER_HTTPS_CERT_PATH_PROPERTY_KEY = ServerSettings.tls_certificate_file.name();
    public static final String DEFAULT_WEBSERVER_HTTPS_CERT_PATH = ServerSettings.tls_certificate_file.getDefaultValue();
    public static final String WEBSERVER_HTTPS_KEY_PATH_PROPERTY_KEY = ServerSettings.tls_key_file.name();
    public static final String DEFAULT_WEBSERVER_HTTPS_KEY_PATH = ServerSettings.tls_key_file.getDefaultValue();
    public static final String HTTP_LOGGING = ServerSettings.http_logging_enabled.name();
    public static final boolean DEFAULT_HTTP_LOGGING = Boolean.valueOf(ServerSettings.http_logging_enabled.getDefaultValue());
    public static final String HTTP_LOG_CONFIG_LOCATION = ServerSettings.http_log_config_file.name();
    public static final String HTTP_CONTENT_LOGGING = ServerSettings.http_content_logging_enabled.name();
    public static final boolean DEFAULT_HTTP_CONTENT_LOGGING = Boolean.valueOf(ServerSettings.http_content_logging_enabled.getDefaultValue());
    public static final String WADL_ENABLED = ServerInternalSettings.wadl_enabled.name();
    public static final String STARTUP_TIMEOUT = ServerInternalSettings.startup_timeout.name();
    public static final int DEFAULT_STARTUP_TIMEOUT = (int)((Long)TimeUtil.parseTimeMillis.apply((Object)ServerInternalSettings.startup_timeout.getDefaultValue()) / 1000L);
    public static final String TRANSACTION_TIMEOUT = ServerSettings.transaction_timeout.name();
    public static final int DEFAULT_TRANSACTION_TIMEOUT = (int)((Long)TimeUtil.parseTimeMillis.apply((Object)ServerSettings.transaction_timeout.getDefaultValue()) / 1000L);
    public static final DiagnosticsExtractor<Configurator> DIAGNOSTICS = new DiagnosticsExtractor<Configurator>(){

        public void dumpDiagnostics(Configurator source, DiagnosticsPhase phase, Logger logger) {
            if (phase.isInitialization() || phase.isExplicitlyRequested()) {
                Configuration config = source.configuration();
                logger.log("Server configuration:");
                Iterator keys = config.getKeys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    logger.log("%s=%s", new Object[]{key, config.getProperty(key)});
                }
            }
        }

        public String toString() {
            return Configurator.class.getName();
        }
    };
    public static final Configurator EMPTY = new Adapter(){};

    public Configuration configuration();

    public Map<String, String> getDatabaseTuningProperties();

    @Deprecated
    public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsClasses();

    public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages();

    public static abstract class Adapter
    implements Configurator {
        @Override
        public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsClasses() {
            return this.getThirdpartyJaxRsPackages();
        }

        @Override
        public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages() {
            return Collections.emptyList();
        }

        @Override
        public Map<String, String> getDatabaseTuningProperties() {
            return Collections.emptyMap();
        }

        @Override
        public Configuration configuration() {
            return new MapConfiguration(Collections.emptyMap());
        }
    }
}

