/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.RrdDbWrapper;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdJob;
import org.neo4j.server.rrd.RrdSamplerImpl;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.server.rrd.sampler.NodeIdsInUseSampleable;
import org.neo4j.server.rrd.sampler.PropertyCountSampleable;
import org.neo4j.server.rrd.sampler.RelationshipCountSampleable;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdToolkit;

public class RrdFactory {
    public static final int STEP_SIZE = 1;
    private static final String RRD_THREAD_NAME = "Statistics Gatherer";
    private final Config config;
    private final Log log;

    public RrdFactory(Config config, LogProvider logProvider) {
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    public RrdDbWrapper createRrdDbAndSampler(Database db, JobScheduler scheduler) throws IOException {
        NeoStoresSupplier neoStoresSupplier = (NeoStoresSupplier)db.getGraph().getDependencyResolver().resolveDependency(NeoStoresSupplier.class);
        Sampleable[] primitives = new Sampleable[]{new NodeIdsInUseSampleable(neoStoresSupplier), new PropertyCountSampleable(neoStoresSupplier), new RelationshipCountSampleable(neoStoresSupplier)};
        Sampleable[] usage = new Sampleable[]{};
        File rrdFile = (File)this.config.get(ServerSettings.rrdb_location);
        if (rrdFile == null || !rrdFile.exists()) {
            Map params = this.config.getParams();
            params.put(ServerSettings.rrdb_location.name(), this.getDefaultRrdFile(db.getGraph()));
            this.config.applyChanges(params);
            rrdFile = (File)this.config.get(ServerSettings.rrdb_location);
        }
        RrdDbWrapper rrdb = this.createRrdb(rrdFile, this.isEphemereal(db.getGraph()), this.join(primitives, usage));
        scheduler.scheduleAtFixedRate(new RrdJob(new RrdSamplerImpl(rrdb.get(), primitives)), "Statistics Gatherer[primitives]", TimeUnit.SECONDS.toMillis(0L), TimeUnit.SECONDS.toMillis(3L));
        return rrdb;
    }

    private Sampleable[] join(Sampleable[] ... sampleables) {
        ArrayList result = new ArrayList();
        for (Sampleable[] sampleable : sampleables) {
            Collections.addAll(result, sampleable);
        }
        return result.toArray(new Sampleable[result.size()]);
    }

    private String getDefaultRrdFile(GraphDatabaseAPI db) throws IOException {
        return this.isEphemereal(db) ? this.tempRrdFile() : new File(db.getStoreDir(), "rrd").getAbsolutePath();
    }

    protected String tempRrdFile() throws IOException {
        final File tempFile = File.createTempFile("neo4j", "rrd");
        tempFile.delete();
        tempFile.mkdir();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteRecursively((File)tempFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        return tempFile.getAbsolutePath();
    }

    private boolean isEphemereal(GraphDatabaseAPI db) {
        Config config = (Config)db.getDependencyResolver().resolveDependency(Config.class);
        if (config == null) {
            return false;
        }
        Boolean ephemeral = (Boolean)config.get(GraphDatabaseFacadeFactory.Configuration.ephemeral);
        return ephemeral != null && ephemeral != false;
    }

    protected RrdDbWrapper createRrdb(File rrdFile, boolean ephemeral, Sampleable ... sampleables) {
        if (rrdFile.exists()) {
            try {
                if (!this.validateStepSize(rrdFile)) {
                    return this.recreateArchive(rrdFile, ephemeral, sampleables);
                }
                Sampleable[] missing = RrdFactory.checkDataSources(rrdFile.getAbsolutePath(), sampleables);
                if (missing.length > 0) {
                    this.updateDataSources(rrdFile.getAbsolutePath(), missing);
                }
                return this.wrap(new RrdDb(rrdFile.getAbsolutePath()), ephemeral);
            }
            catch (IOException e) {
                this.log.error("Unable to open rrd store, attempting to recreate it", (Throwable)e);
                return this.recreateArchive(rrdFile, ephemeral, sampleables);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Unable to open rrd store, attempting to recreate it", (Throwable)e);
                return this.recreateArchive(rrdFile, ephemeral, sampleables);
            }
        }
        RrdDef rrdDef = new RrdDef(rrdFile.getAbsolutePath(), 1L);
        this.defineDataSources(rrdDef, sampleables);
        this.addArchives(rrdDef);
        try {
            return this.wrap(new RrdDb(rrdDef), ephemeral);
        }
        catch (IOException e) {
            this.log.error("Unable to create new rrd store", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private RrdDbWrapper wrap(RrdDb db, boolean ephemeral) throws IOException {
        return ephemeral ? this.cleaningRrdDb(db) : new RrdDbWrapper.Plain(db);
    }

    private RrdDbWrapper cleaningRrdDb(final RrdDb db) {
        return new RrdDbWrapper(){

            @Override
            public RrdDb get() {
                return db;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    db.close();
                }
                finally {
                    new File(db.getPath()).delete();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateStepSize(File rrdFile) throws IOException {
        try (RrdDb r = null;){
            r = new RrdDb(rrdFile.getAbsolutePath(), true);
            boolean bl = r.getRrdDef().getStep() == 1L;
            return bl;
        }
    }

    private RrdDbWrapper recreateArchive(File rrdFile, boolean ephemeral, Sampleable[] sampleables) {
        File file = new File(rrdFile.getParentFile(), rrdFile.getName() + "-invalid-" + System.currentTimeMillis());
        if (rrdFile.renameTo(file)) {
            this.log.error("current RRDB is invalid, renamed it to %s", new Object[]{file.getAbsolutePath()});
            return this.createRrdb(rrdFile, ephemeral, sampleables);
        }
        throw new RuntimeException("RRD file ['" + rrdFile.getAbsolutePath() + "'] is invalid, but I do not have write permissions to recreate it.");
    }

    private static Sampleable[] checkDataSources(String rrdPath, Sampleable[] sampleables) throws IOException {
        RrdDb rrdDb = new RrdDb(rrdPath, true);
        ArrayList<Sampleable> missing = new ArrayList<Sampleable>();
        for (Sampleable sampleable : sampleables) {
            if (rrdDb.getDatasource(sampleable.getName()) != null) continue;
            missing.add(sampleable);
        }
        rrdDb.close();
        return missing.toArray(new Sampleable[missing.size()]);
    }

    private void updateDataSources(String rrdPath, Sampleable[] sampleables) throws IOException {
        for (Sampleable sampleable : sampleables) {
            this.log.warn("Updating RRDB structure, adding: " + sampleable.getName());
            RrdToolkit.addDatasource((String)rrdPath, (DsDef)RrdFactory.createDsDef(sampleable), (boolean)true);
        }
    }

    private static DsDef createDsDef(Sampleable sampleable) {
        return new DsDef(sampleable.getName(), sampleable.getType(), 120L, Double.NaN, Double.NaN);
    }

    private void addArchives(RrdDef rrdDef) {
        for (ConsolFun fun : Arrays.asList(ConsolFun.AVERAGE, ConsolFun.MAX, ConsolFun.MIN)) {
            this.addArchive(rrdDef, fun, TimeUnit.MINUTES.toSeconds(30L), TimeUnit.SECONDS.toSeconds(1L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(1L), TimeUnit.MINUTES.toSeconds(1L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(7L), TimeUnit.MINUTES.toSeconds(5L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(30L), TimeUnit.MINUTES.toSeconds(30L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(1780L), TimeUnit.HOURS.toSeconds(2L));
        }
    }

    private void addArchive(RrdDef rrdDef, ConsolFun fun, long length, long resolution) {
        rrdDef.addArchive(fun, 0.2, (int)(resolution * 1L), (int)(length / (resolution * 1L)));
    }

    private void defineDataSources(RrdDef rrdDef, Sampleable[] sampleables) {
        for (Sampleable sampleable : sampleables) {
            rrdDef.addDatasource(RrdFactory.createDsDef(sampleable));
        }
    }
}

