/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.representations;

import java.lang.management.ManagementFactory;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationDispatcher;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.rest.representations.JmxAttributeRepresentationDispatcher;

public class JmxAttributeRepresentation
extends ObjectRepresentation {
    protected ObjectName objectName;
    protected MBeanAttributeInfo attrInfo;
    protected MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
    private static final RepresentationDispatcher REPRESENTATION_DISPATCHER = new JmxAttributeRepresentationDispatcher();

    public JmxAttributeRepresentation(ObjectName objectName, MBeanAttributeInfo attrInfo) {
        super("jmxAttribute");
        this.objectName = objectName;
        this.attrInfo = attrInfo;
    }

    @ObjectRepresentation.Mapping(value="name")
    public ValueRepresentation getName() {
        return ValueRepresentation.string((String)this.attrInfo.getName());
    }

    @ObjectRepresentation.Mapping(value="description")
    public ValueRepresentation getDescription() {
        return ValueRepresentation.string((String)this.attrInfo.getDescription());
    }

    @ObjectRepresentation.Mapping(value="type")
    public ValueRepresentation getType() {
        return ValueRepresentation.string((String)this.attrInfo.getType());
    }

    @ObjectRepresentation.Mapping(value="isReadable")
    public ValueRepresentation isReadable() {
        return this.bool(this.attrInfo.isReadable());
    }

    @ObjectRepresentation.Mapping(value="isWriteable")
    public ValueRepresentation isWriteable() {
        return this.bool(this.attrInfo.isWritable());
    }

    @ObjectRepresentation.Mapping(value="isIs")
    public ValueRepresentation isIs() {
        return this.bool(this.attrInfo.isIs());
    }

    private ValueRepresentation bool(Boolean value) {
        return ValueRepresentation.string((String)(value != false ? "true" : "false "));
    }

    @ObjectRepresentation.Mapping(value="value")
    public Representation getValue() {
        try {
            Object value = this.jmxServer.getAttribute(this.objectName, this.attrInfo.getName());
            return (Representation)REPRESENTATION_DISPATCHER.dispatch(value, "");
        }
        catch (Exception e) {
            return ValueRepresentation.string((String)"N/A");
        }
    }
}

