/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Map;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.ObjectToRepresentationConverter;
import org.neo4j.server.rest.repr.RepresentationType;

public class MapRepresentation
extends MappingRepresentation {
    private final Map value;

    public MapRepresentation(Map value) {
        super(RepresentationType.MAP);
        this.value = value;
    }

    protected void serialize(MappingSerializer serializer) {
        for (Object key : this.value.keySet()) {
            Object val = this.value.get(key);
            if (val instanceof Number) {
                serializer.putNumber(key.toString(), (Number)val);
                continue;
            }
            if (val instanceof Boolean) {
                serializer.putBoolean(key.toString(), ((Boolean)val).booleanValue());
                continue;
            }
            if (val instanceof String) {
                serializer.putString(key.toString(), (String)val);
                continue;
            }
            if (val instanceof Iterable) {
                serializer.putList(key.toString(), ObjectToRepresentationConverter.getListRepresentation((Iterable)val));
                continue;
            }
            if (val instanceof Map) {
                serializer.putMapping(key.toString(), ObjectToRepresentationConverter.getMapRepresentation((Map)val));
                continue;
            }
            if (val == null) {
                serializer.putString(key.toString(), null);
                continue;
            }
            serializer.putString(key.toString(), val.toString());
        }
    }
}

