/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/")
public class DiscoveryService {
    private static final Logger LOGGER = Log.getLogger(DiscoveryService.class);
    private final Configuration configuration;
    private final OutputFormat outputFormat;

    public DiscoveryService(@Context Configuration configuration, @Context OutputFormat outputFormat) {
        this.configuration = configuration;
        this.outputFormat = outputFormat;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDiscoveryDocument() throws URISyntaxException {
        String webAdminManagementUri = this.configuration.getString("org.neo4j.server.webadmin.management.uri", "/db/manage");
        String dataUri = this.configuration.getString("org.neo4j.server.webadmin.data.uri", "/db/data");
        DiscoveryRepresentation dr = new DiscoveryRepresentation(webAdminManagementUri, dataUri);
        return this.outputFormat.ok((Representation)dr);
    }

    @GET
    @Produces(value={"*/*"})
    public Response redirectToBrowser() {
        try {
            return Response.seeOther((URI)new URI("/browser")).build();
        }
        catch (URISyntaxException e) {
            LOGGER.warn(e.getMessage(), new Object[0]);
            return Response.serverError().build();
        }
    }
}

