/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class Neo4jBrowserModule
implements ServerModule {
    private static final Logger log = Logger.getLogger(Neo4jBrowserModule.class);
    private static final String DEFAULT_NEO4J_BROWSER_PATH = "/browser";
    private static final String DEFAULT_NEO4J_BROWSER_STATIC_WEB_CONTENT_LOCATION = "browser";
    private final Configuration config;
    private final WebServer webServer;
    private final Database database;

    public Neo4jBrowserModule(WebServer webServer, Configuration config, Database database) {
        this.webServer = webServer;
        this.config = config;
        this.database = database;
    }

    @Override
    public void start(StringLogger logger) {
        this.webServer.addStaticContent(DEFAULT_NEO4J_BROWSER_STATIC_WEB_CONTENT_LOCATION, DEFAULT_NEO4J_BROWSER_PATH);
        log.info("Mounted Neo4j Browser at [%s]", DEFAULT_NEO4J_BROWSER_PATH);
        if (logger != null) {
            logger.logMessage("Mounted Neo4j Browser at: /browser");
        }
    }

    @Override
    public void stop() {
        this.webServer.removeStaticContent(DEFAULT_NEO4J_BROWSER_STATIC_WEB_CONTENT_LOCATION, DEFAULT_NEO4J_BROWSER_PATH);
    }
}

