/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import java.util.HashMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.neo4j.kernel.logging.ModuleConverter;
import org.slf4j.LoggerFactory;

public class SimpleConsoleFormatter
extends Formatter {
    private final PatternLayoutEncoder encoder;

    public SimpleConsoleFormatter() {
        LoggerContext context = new LoggerContext();
        HashMap<String, String> converters = new HashMap<String, String>();
        converters.put("module", ModuleConverter.class.getName());
        context.putObject("PATTERN_RULE_REGISTRY", converters);
        this.encoder = new PatternLayoutEncoder();
        this.encoder.setContext((Context)context);
        this.encoder.setPattern("%date{yyyy-MM-dd HH:mm:ss.SSSZ,UTC} %-5level [%module] %message%n");
        this.encoder.start();
    }

    @Override
    public synchronized String format(LogRecord record) {
        LoggingEvent event = new LoggingEvent(record.getLoggerName(), (Logger)LoggerFactory.getLogger((String)record.getLoggerName()), Level.toLevel((String)record.getLevel().getName()), record.getMessage(), record.getThrown(), record.getParameters());
        return this.encoder.getLayout().doLayout((Object)event);
    }
}

