/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CommunityDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.DiscoveryModule;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.modules.Neo4jBrowserModule;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.SecurityRulesModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.StatisticModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.modules.WebAdminModule;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;
import org.neo4j.server.preflight.PerformUpgradeIfNecessary;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.JmxService;
import org.neo4j.server.webadmin.rest.MonitorService;
import org.neo4j.server.webadmin.rest.console.ConsoleService;

public class CommunityNeoServer
extends AbstractNeoServer {
    public CommunityNeoServer() {
    }

    public CommunityNeoServer(Configurator configurator) {
        this.configurator = configurator;
        this.init();
    }

    @Override
    protected PreFlightTasks createPreflightTasks() {
        return new PreFlightTasks(new EnsurePreparedForHttpLogging(this.configurator.configuration()), new PerformUpgradeIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out), new PerformRecoveryIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out));
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        return Arrays.asList(new DiscoveryModule(this.webServer), new RESTApiModule(this.webServer, this.database, this.configurator.configuration()), new ManagementApiModule(this.webServer, this.configurator.configuration()), new ThirdPartyJAXRSModule(this.webServer, this.configurator, this), new WebAdminModule(this.webServer, this.configurator.configuration(), this.database), new Neo4jBrowserModule(this.webServer, this.configurator.configuration(), this.database), new StatisticModule(this.webServer, this.statisticsCollector, this.configurator.configuration()), new SecurityRulesModule(this.webServer, this.configurator.configuration()));
    }

    @Override
    protected Database createDatabase() {
        return new CommunityDatabase(this.configurator);
    }

    @Override
    protected WebServer createWebServer() {
        return new Jetty9WebServer();
    }

    @Override
    public Iterable<AdvertisableService> getServices() {
        ArrayList<AdvertisableService> toReturn = new ArrayList<AdvertisableService>(3);
        toReturn.add(new ConsoleService(null, null, null));
        toReturn.add(new JmxService(null, null));
        toReturn.add(new MonitorService(null, null));
        return toReturn;
    }
}

