/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.representations;

import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLEncoder;
import java.util.Arrays;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.rest.representations.JmxAttributeRepresentation;

public class JmxMBeanRepresentation
extends ObjectRepresentation {
    protected ObjectName beanName;
    protected MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();

    public JmxMBeanRepresentation(ObjectName beanInstance) {
        super("jmxBean");
        this.beanName = beanInstance;
    }

    @ObjectRepresentation.Mapping(value="name")
    public ValueRepresentation getName() {
        return ValueRepresentation.string((String)this.beanName.getCanonicalName());
    }

    @ObjectRepresentation.Mapping(value="url")
    public ValueRepresentation getUrl() {
        try {
            String value = URLEncoder.encode(this.beanName.toString(), "UTF-8").replace("%3A", "/");
            return ValueRepresentation.string((String)value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encode string as UTF-8", e);
        }
    }

    @ObjectRepresentation.Mapping(value="description")
    public ValueRepresentation getDescription() throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        MBeanInfo beanInfo = this.jmxServer.getMBeanInfo(this.beanName);
        return ValueRepresentation.string((String)beanInfo.getDescription());
    }

    @ObjectRepresentation.Mapping(value="attributes")
    public ListRepresentation getAttributes() throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        MBeanInfo beanInfo = this.jmxServer.getMBeanInfo(this.beanName);
        return new ListRepresentation("jmxAttribute", (Iterable)new IterableWrapper<Representation, MBeanAttributeInfo>(Arrays.asList(beanInfo.getAttributes())){

            protected Representation underlyingObjectToObject(MBeanAttributeInfo attrInfo) {
                return new JmxAttributeRepresentation(JmxMBeanRepresentation.this.beanName, attrInfo);
            }
        });
    }
}

