/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.error;

public enum StatusCode {
    NETWORK_ERROR(30000, StackTraceStrategy.SEND_TO_CLIENT),
    INVALID_REQUEST(40000),
    INVALID_REQUEST_FORMAT(40001),
    INVALID_TRANSACTION_ID(40010),
    INVALID_CONCURRENT_TRANSACTION_ACCESS(40011),
    STATEMENT_EXECUTION_ERROR(42000),
    STATEMENT_SYNTAX_ERROR(42001),
    STATEMENT_MISSING_PARAMETER(42002),
    COULD_NOT_CREATE_INDEX(42101),
    COULD_NOT_DROP_INDEX(42102),
    COULD_NOT_CREATE_CONSTRAINT(42103),
    COULD_NOT_DROP_CONSTRAINT(42104),
    INTERNAL_DATABASE_ERROR(50000, StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_STATEMENT_EXECUTION_ERROR(50001, StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_BEGIN_TRANSACTION_ERROR(53010, StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_ROLLBACK_TRANSACTION_ERROR(53011, StackTraceStrategy.SEND_TO_CLIENT),
    INTERNAL_COMMIT_TRANSACTION_ERROR(53012, StackTraceStrategy.SEND_TO_CLIENT);

    private final int code;
    private final StackTraceStrategy stackTraceStrategy;

    private StatusCode(int code) {
        this(code, StackTraceStrategy.SWALLOW);
    }

    private StatusCode(int code, StackTraceStrategy stackTraceStrategy) {
        this.code = code;
        this.stackTraceStrategy = stackTraceStrategy;
    }

    public int getCode() {
        return this.code;
    }

    public boolean includeStackTrace() {
        return StackTraceStrategy.SEND_TO_CLIENT == this.stackTraceStrategy;
    }

    static enum StackTraceStrategy {
        SWALLOW,
        SEND_TO_CLIENT;

    }
}

