/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.repr.RepresentationWriteHandler;
import org.neo4j.server.rest.transactional.CommitOnSuccessfulStatusCodeRepresentationWriteHandler;
import org.neo4j.server.rest.web.BatchOperationService;
import org.neo4j.server.rest.web.CypherService;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.server.rest.web.ExtensionService;
import org.neo4j.server.rest.web.RestfulGraphDatabase;

public class TransactionalRequestDispatcher
implements RequestDispatcher {
    private final Database database;
    private final RequestDispatcher requestDispatcher;

    public TransactionalRequestDispatcher(Database database, RequestDispatcher requestDispatcher) {
        this.database = database;
        this.requestDispatcher = requestDispatcher;
    }

    public void dispatch(Object o, HttpContext httpContext) {
        if (o instanceof RestfulGraphDatabase) {
            RestfulGraphDatabase restfulGraphDatabase = (RestfulGraphDatabase)o;
            Transaction transaction = this.database.getGraph().beginTx();
            restfulGraphDatabase.getOutputFormat().setRepresentationWriteHandler(new CommitOnSuccessfulStatusCodeRepresentationWriteHandler(httpContext, transaction));
        } else if (o instanceof BatchOperationService) {
            BatchOperationService batchOperationService = (BatchOperationService)o;
            Transaction transaction = this.database.getGraph().beginTx();
            batchOperationService.setRepresentationWriteHandler(new CommitOnSuccessfulStatusCodeRepresentationWriteHandler(httpContext, transaction));
        } else if (o instanceof CypherService) {
            CypherService cypherService = (CypherService)o;
            Transaction transaction = this.database.getGraph().beginTx();
            cypherService.getOutputFormat().setRepresentationWriteHandler(new CommitOnSuccessfulStatusCodeRepresentationWriteHandler(httpContext, transaction));
        } else if (o instanceof DatabaseMetadataService) {
            DatabaseMetadataService databaseMetadataService = (DatabaseMetadataService)o;
            final Transaction transaction = this.database.getGraph().beginTx();
            databaseMetadataService.setRepresentationWriteHandler(new RepresentationWriteHandler(){

                @Override
                public void onRepresentationStartWriting() {
                }

                @Override
                public void onRepresentationWritten() {
                }

                @Override
                public void onRepresentationFinal() {
                    transaction.finish();
                }
            });
        } else if (o instanceof ExtensionService) {
            ExtensionService extensionService = (ExtensionService)o;
            extensionService.getOutputFormat().setRepresentationWriteHandler(new RepresentationWriteHandler(){
                Transaction transaction;

                @Override
                public void onRepresentationStartWriting() {
                    this.transaction = TransactionalRequestDispatcher.this.database.getGraph().beginTx();
                }

                @Override
                public void onRepresentationWritten() {
                }

                @Override
                public void onRepresentationFinal() {
                    if (this.transaction != null) {
                        this.transaction.finish();
                    }
                }
            });
        }
        this.requestDispatcher.dispatch(o, httpContext);
    }
}

