/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.Iterator;
import java.util.List;
import org.neo4j.server.rest.transactional.GraphExtractionWriter;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;
import org.neo4j.server.rest.transactional.RowWriter;

public enum ResultDataContent {
    row{

        @Override
        public ResultDataContentWriter writer() {
            return new RowWriter();
        }
    }
    ,
    graph{

        @Override
        public ResultDataContentWriter writer() {
            return new GraphExtractionWriter();
        }
    };


    public abstract ResultDataContentWriter writer();

    public static ResultDataContent[] fromNames(List<?> names) {
        if (names == null || names.isEmpty()) {
            return null;
        }
        ResultDataContent[] result = new ResultDataContent[names.size()];
        Iterator<?> name = names.iterator();
        for (int i = 0; i < result.length; ++i) {
            Object contentName = name.next();
            if (contentName instanceof String) {
                try {
                    result[i] = ResultDataContent.valueOf(((String)contentName).toLowerCase());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid result data content specifier: " + contentName);
                }
            }
            throw new IllegalArgumentException("Invalid result data content specifier: " + contentName);
        }
        return result;
    }
}

