/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.rest.repr.util.RFC1123;
import org.neo4j.server.rest.transactional.AggregatingWriter;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.neo4j.server.rest.transactional.ResultDataContent;
import org.neo4j.server.rest.transactional.ResultDataContentWriter;
import org.neo4j.server.rest.transactional.error.Neo4jError;

public class ExecutionResultSerializer {
    private State currentState = State.EMPTY;
    private static final JsonFactory JSON_FACTORY = new JsonFactory((ObjectCodec)new Neo4jJsonCodec());
    private final JsonGenerator out;
    private final StringLogger log;

    public ExecutionResultSerializer(OutputStream output, StringLogger log) {
        this.log = log;
        JsonGenerator generator = null;
        try {
            generator = JSON_FACTORY.createJsonGenerator(output);
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
        this.out = generator;
    }

    public void transactionCommitUri(URI commitUri) {
        try {
            this.ensureDocumentOpen();
            this.out.writeStringField("commit", commitUri.toString());
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statementResult(ExecutionResult result, ResultDataContent ... resultDataContents) throws IOException {
        try {
            this.ensureResultsFieldOpen();
            this.out.writeStartObject();
            try {
                List columns = result.columns();
                this.writeColumns(columns);
                this.writeRows(columns, (Iterator<Map<String, Object>>)result.iterator(), this.configureWriters(resultDataContents));
            }
            finally {
                this.out.writeEndObject();
            }
        }
        catch (IOException e) {
            throw this.loggedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errors(Iterable<? extends Neo4jError> errors) {
        try {
            this.ensureDocumentOpen();
            this.ensureResultsFieldClosed();
            this.out.writeArrayFieldStart("errors");
            try {
                for (Neo4jError neo4jError : errors) {
                    try {
                        this.out.writeStartObject();
                        this.out.writeObjectField("code", (Object)neo4jError.getStatusCode().getCode());
                        this.out.writeObjectField("status", (Object)neo4jError.getStatusCode().name());
                        this.out.writeObjectField("message", (Object)neo4jError.getMessage());
                        if (!neo4jError.shouldSerializeStackTrace()) continue;
                        this.out.writeObjectField("stackTrace", (Object)neo4jError.getStackTraceAsString());
                    }
                    finally {
                        this.out.writeEndObject();
                    }
                }
            }
            finally {
                this.out.writeEndArray();
                this.currentState = State.ERRORS_WRITTEN;
            }
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    public void transactionStatus(long expiryDate) {
        try {
            this.ensureDocumentOpen();
            this.ensureResultsFieldClosed();
            this.out.writeObjectFieldStart("transaction");
            this.out.writeStringField("expires", RFC1123.formatDate(new Date(expiryDate)));
            this.out.writeEndObject();
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    public void finish() {
        try {
            this.ensureDocumentOpen();
            if (this.currentState != State.ERRORS_WRITTEN) {
                this.errors(Collections.emptyList());
            }
            this.out.writeEndObject();
            this.out.flush();
        }
        catch (IOException e) {
            this.loggedIOException(e);
        }
    }

    private ResultDataContentWriter configureWriters(ResultDataContent[] specifiers) {
        if (specifiers == null || specifiers.length == 0) {
            return ResultDataContent.row.writer();
        }
        if (specifiers.length == 1) {
            return specifiers[0].writer();
        }
        ResultDataContentWriter[] writers = new ResultDataContentWriter[specifiers.length];
        for (int i = 0; i < specifiers.length; ++i) {
            writers[i] = specifiers[i].writer();
        }
        return new AggregatingWriter(writers);
    }

    private void ensureDocumentOpen() throws IOException {
        if (this.currentState == State.EMPTY) {
            this.out.writeStartObject();
            this.currentState = State.DOCUMENT_OPEN;
        }
    }

    private void ensureResultsFieldOpen() throws IOException {
        this.ensureDocumentOpen();
        if (this.currentState == State.DOCUMENT_OPEN) {
            this.out.writeArrayFieldStart("results");
            this.currentState = State.RESULTS_OPEN;
        }
    }

    private void ensureResultsFieldClosed() throws IOException {
        this.ensureResultsFieldOpen();
        if (this.currentState == State.RESULTS_OPEN) {
            this.out.writeEndArray();
            this.currentState = State.RESULTS_CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRows(Iterable<String> columns, Iterator<Map<String, Object>> data, ResultDataContentWriter writer) throws IOException {
        this.out.writeArrayFieldStart("data");
        try {
            while (data.hasNext()) {
                Map<String, Object> row = data.next();
                this.out.writeStartObject();
                try {
                    writer.write(this.out, columns, row);
                }
                finally {
                    this.out.writeEndObject();
                }
            }
        }
        finally {
            this.out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeColumns(Iterable<String> columns) throws IOException {
        try {
            this.out.writeArrayFieldStart("columns");
            for (String key : columns) {
                this.out.writeString(key);
            }
        }
        finally {
            this.out.writeEndArray();
        }
    }

    private IOException loggedIOException(IOException exception) {
        this.log.error("Failed to generate JSON output.", (Throwable)exception);
        return exception;
    }

    private static enum State {
        EMPTY,
        DOCUMENT_OPEN,
        RESULTS_OPEN,
        RESULTS_CLOSED,
        ERRORS_WRITTEN;

    }
}

