/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.InvalidServerConfigurationException;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.logging.Logger;

public class PropertyFileConfigurator
implements Configurator {
    private static final String NEO4J_PROPERTIES_FILENAME = "neo4j.properties";
    public static final Logger log = Logger.getLogger(PropertyFileConfigurator.class);
    private final CompositeConfiguration serverConfiguration = new CompositeConfiguration();
    private File propertyFileDirectory;
    private final Validator validator = new Validator(new ValidationRule[0]);
    private Map<String, String> databaseTuningProperties = null;
    private HashSet<ThirdPartyJaxRsPackage> thirdPartyPackages;

    public PropertyFileConfigurator(File propertiesFile) {
        this(null, propertiesFile);
    }

    public PropertyFileConfigurator(Validator v) {
        this(v, null);
    }

    public PropertyFileConfigurator(Validator v, File propertiesFile) {
        if (propertiesFile == null) {
            propertiesFile = new File(System.getProperty("org.neo4j.server.properties"));
        }
        try {
            this.propertyFileDirectory = propertiesFile.getParentFile();
            this.loadPropertiesConfig(propertiesFile);
            this.loadDatabaseTuningProperties(propertiesFile);
            this.normalizeUris();
            this.ensureRelativeUris();
            if (v != null) {
                v.validate(this.configuration());
            }
        }
        catch (ConfigurationException ce) {
            log.warn(ce);
        }
    }

    @Override
    public Configuration configuration() {
        return this.serverConfiguration == null ? new SystemConfiguration() : this.serverConfiguration;
    }

    private void loadDatabaseTuningProperties(File configFile) throws ConfigurationException {
        File databaseTuningPropertyFile;
        String databaseTuningPropertyFileLocation = this.serverConfiguration.getString("org.neo4j.server.db.tuning.properties");
        if (databaseTuningPropertyFileLocation == null) {
            if (this.propertyFileDirectoryContainsDBTuningFile()) {
                databaseTuningPropertyFileLocation = new File(this.propertyFileDirectory, NEO4J_PROPERTIES_FILENAME).getAbsolutePath();
                log.info("No database tuning file explicitly set, defaulting to [%s]", databaseTuningPropertyFileLocation);
            } else {
                log.info("No database tuning properties (org.neo4j.server.db.tuning.properties) found in [%s], using defaults.", databaseTuningPropertyFileLocation);
                return;
            }
        }
        if (!(databaseTuningPropertyFile = new File(databaseTuningPropertyFileLocation)).exists()) {
            log.warn("The specified file for database performance tuning properties [%s] does not exist.", databaseTuningPropertyFileLocation);
            return;
        }
        try {
            this.databaseTuningProperties = MapUtil.load((File)databaseTuningPropertyFile);
        }
        catch (IOException e) {
            this.databaseTuningProperties = new HashMap<String, String>();
        }
    }

    private void loadPropertiesConfig(File configFile) throws ConfigurationException {
        PropertiesConfiguration propertiesConfig = new PropertiesConfiguration(configFile);
        if (!this.validator.validate((Configuration)propertiesConfig)) {
            String failed = String.format("Error processing [%s], configuration file has failed validation.", configFile.getAbsolutePath());
            log.fatal(failed, new Object[0]);
            throw new InvalidServerConfigurationException(failed);
        }
        this.serverConfiguration.addConfiguration((Configuration)propertiesConfig);
    }

    private void normalizeUris() {
        try {
            for (String key : new String[]{"org.neo4j.server.webadmin.management.uri", "org.neo4j.server.webadmin.data.uri"}) {
                if (!this.configuration().containsKey(key)) continue;
                URI normalizedUri = new URI((String)this.configuration().getProperty(key)).normalize();
                this.configuration().clearProperty(key);
                this.configuration().addProperty(key, (Object)normalizedUri.toString());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureRelativeUris() {
        try {
            for (String key : new String[]{"org.neo4j.server.webadmin.management.uri", "org.neo4j.server.webadmin.data.uri"}) {
                if (!this.configuration().containsKey(key)) continue;
                String path = new URI((String)this.configuration().getProperty(key)).getPath();
                this.configuration().clearProperty(key);
                this.configuration().addProperty(key, (Object)path);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean propertyFileDirectoryContainsDBTuningFile() {
        File[] neo4jPropertyFiles = this.propertyFileDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().equals(PropertyFileConfigurator.NEO4J_PROPERTIES_FILENAME);
            }
        });
        return neo4jPropertyFiles != null && neo4jPropertyFiles.length == 1;
    }

    public File getPropertyFileDirectory() {
        return this.propertyFileDirectory;
    }

    @Override
    public Map<String, String> getDatabaseTuningProperties() {
        return this.databaseTuningProperties == null ? new HashMap() : this.databaseTuningProperties;
    }

    @Override
    public Set<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages() {
        this.thirdPartyPackages = new HashSet();
        Properties properties = this.configuration().getProperties("org.neo4j.server.thirdparty_jaxrs_classes");
        for (Object key : properties.keySet()) {
            this.thirdPartyPackages.add(new ThirdPartyJaxRsPackage(key.toString(), properties.getProperty(key.toString())));
        }
        return this.thirdPartyPackages;
    }
}

