/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Timer;
import java.util.TimerTask;

public abstract class InterruptThreadTimer {
    public static InterruptThreadTimer createTimer(long timeoutMillis, Thread threadToInterrupt) {
        return new ActualInterruptThreadTimer(timeoutMillis, threadToInterrupt);
    }

    public static InterruptThreadTimer createNoOpTimer() {
        return new NoOpInterruptThreadTimer();
    }

    public abstract void startCountdown();

    public abstract void stopCountdown();

    public abstract boolean wasTriggered();

    public abstract State getState();

    public abstract long getTimeoutMillis();

    private static class NoOpInterruptThreadTimer
    extends InterruptThreadTimer {
        private State state = State.IDLE;

        @Override
        public void startCountdown() {
            this.state = State.COUNTING;
        }

        @Override
        public void stopCountdown() {
            this.state = State.IDLE;
        }

        @Override
        public State getState() {
            return this.state;
        }

        @Override
        public boolean wasTriggered() {
            return false;
        }

        @Override
        public long getTimeoutMillis() {
            return 0L;
        }
    }

    private static class ActualInterruptThreadTimer
    extends InterruptThreadTimer {
        private final Timer timer = new Timer();
        private final InterruptThreadTask task;
        private final long timeout;
        private State state = State.IDLE;

        public ActualInterruptThreadTimer(long timeoutMillis, Thread threadToInterrupt) {
            this.task = new InterruptThreadTask(threadToInterrupt);
            this.timeout = timeoutMillis;
        }

        @Override
        public void startCountdown() {
            this.state = State.COUNTING;
            this.timer.schedule((TimerTask)this.task, this.timeout);
        }

        @Override
        public void stopCountdown() {
            this.state = State.IDLE;
            this.timer.cancel();
        }

        @Override
        public State getState() {
            switch (this.state) {
                case IDLE: {
                    return State.IDLE;
                }
            }
            if (this.wasTriggered()) {
                this.state = State.IDLE;
            }
            return this.state;
        }

        @Override
        public boolean wasTriggered() {
            return this.task.wasExecuted();
        }

        @Override
        public long getTimeoutMillis() {
            return this.timeout;
        }
    }

    public static class InterruptThreadTask
    extends TimerTask {
        private final Thread threadToInterrupt;
        private boolean wasExecuted = false;

        public InterruptThreadTask(Thread threadToInterrupt) {
            this.threadToInterrupt = threadToInterrupt;
        }

        @Override
        public void run() {
            this.wasExecuted = true;
            this.threadToInterrupt.interrupt();
        }

        public boolean wasExecuted() {
            return this.wasExecuted;
        }
    }

    public static enum State {
        COUNTING,
        IDLE;

    }
}

