/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.rest.transactional.CypherExceptionMapping;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalTxManagementTransactionContext;
import org.neo4j.server.rest.transactional.error.InternalBeginTransactionError;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.StatusCode;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionHandle {
    private static final CypherExceptionMapping EXCEPTION_MAPPING = new CypherExceptionMapping();
    private final KernelAPI kernel;
    private final ExecutionEngine engine;
    private final TransactionRegistry registry;
    private final TransactionUriScheme uriScheme;
    private final StringLogger log;
    private final long id;
    private TransitionalTxManagementTransactionContext context;

    public TransactionHandle(KernelAPI kernel, ExecutionEngine engine, TransactionRegistry registry, TransactionUriScheme uriScheme, StringLogger log) {
        this.kernel = kernel;
        this.engine = engine;
        this.registry = registry;
        this.uriScheme = uriScheme;
        this.log = log;
        this.id = registry.begin();
    }

    public URI uri() {
        return this.uriScheme.txUri(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StatementDeserializer statements, ExecutionResultSerializer output) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            output.transactionCommitUri(this.uriScheme.txCommitUri(this.id));
            this.ensureActiveTransaction();
            this.execute(statements, output, errors);
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(StatementDeserializer statements, ExecutionResultSerializer output) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            this.ensureActiveTransaction();
            this.commit(statements, output, errors);
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(ExecutionResultSerializer output) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            this.ensureActiveTransaction();
            this.rollback(errors);
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    public void forceRollback() {
        this.context.resumeSinceTransactionsAreStillThreadBound();
        this.context.rollback();
    }

    private void ensureActiveTransaction() throws InternalBeginTransactionError {
        if (this.context == null) {
            try {
                this.context = (TransitionalTxManagementTransactionContext)this.kernel.newTransactionContext();
            }
            catch (RuntimeException e) {
                this.log.error("Failed to start transaction.", (Throwable)e);
                throw new InternalBeginTransactionError(e);
            }
        } else {
            this.context.resumeSinceTransactionsAreStillThreadBound();
        }
    }

    private void execute(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors) {
        this.executeStatements(statements, output, errors);
        if (errors.isEmpty()) {
            this.context.suspendSinceTransactionsAreStillThreadBound();
            this.registry.release(this.id, this);
        } else {
            this.rollback(errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors) {
        try {
            this.executeStatements(statements, output, errors);
            if (errors.isEmpty()) {
                try {
                    this.context.commit();
                }
                catch (RuntimeException e) {
                    this.log.error("Failed to commit transaction.", (Throwable)e);
                    errors.add(new Neo4jError(StatusCode.INTERNAL_COMMIT_TRANSACTION_ERROR, e));
                }
            } else {
                try {
                    this.context.rollback();
                }
                catch (RuntimeException e) {
                    this.log.error("Failed to rollback transaction.", (Throwable)e);
                    errors.add(new Neo4jError(StatusCode.INTERNAL_ROLLBACK_TRANSACTION_ERROR, e));
                }
            }
        }
        finally {
            this.registry.forget(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(List<Neo4jError> errors) {
        try {
            this.context.rollback();
        }
        catch (RuntimeException e) {
            this.log.error("Failed to rollback transaction.", (Throwable)e);
            errors.add(new Neo4jError(StatusCode.INTERNAL_ROLLBACK_TRANSACTION_ERROR, e));
        }
        finally {
            this.registry.forget(this.id);
        }
    }

    private void executeStatements(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors) {
        try {
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                try {
                    ExecutionResult result = this.engine.execute(statement.statement(), statement.parameters());
                    output.statementResult(result);
                }
                catch (CypherException e) {
                    errors.add(new Neo4jError(EXCEPTION_MAPPING.apply(e), e));
                    break;
                }
                catch (IOException e) {
                    errors.add(new Neo4jError(StatusCode.NETWORK_ERROR, e));
                    break;
                }
                catch (RuntimeException e) {
                    errors.add(new Neo4jError(StatusCode.INTERNAL_STATEMENT_EXECUTION_ERROR, e));
                    break;
                }
            }
            Iterator<Neo4jError> deserializationErrors = statements.errors();
            while (deserializationErrors.hasNext()) {
                errors.add(deserializationErrors.next());
            }
        }
        catch (RuntimeException e) {
            errors.add(new Neo4jError(StatusCode.INTERNAL_DATABASE_ERROR, e));
        }
    }
}

