/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.StatusCode;

public class StatementDeserializer
extends PrefetchingIterator<Statement> {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().setCodec((ObjectCodec)new Neo4jJsonCodec());
    private static final Map<String, Object> NO_PARAMETERS = Collections.unmodifiableMap(MapUtil.map((Object[])new Object[0]));
    private static final Iterator<Neo4jError> NO_ERRORS = IteratorUtil.emptyIterator();
    private final JsonParser input;
    private State state;
    private List<Neo4jError> errors = null;

    public StatementDeserializer(InputStream input) {
        try {
            this.input = JSON_FACTORY.createJsonParser(input);
            this.state = State.BEFORE_OUTER_ARRAY;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Neo4jError> errors() {
        return this.errors == null ? NO_ERRORS : this.errors.iterator();
    }

    protected Statement fetchNextOrNull() {
        try {
            if (this.errors != null) {
                return null;
            }
            switch (this.state) {
                case BEFORE_OUTER_ARRAY: {
                    if (!this.beginsWithCorrectTokens()) {
                        return null;
                    }
                    this.state = State.IN_BODY;
                }
                case IN_BODY: {
                    JsonToken tok;
                    String statement = null;
                    Map<String, Object> parameters = null;
                    while ((tok = this.input.nextToken()) != null && tok != JsonToken.END_OBJECT) {
                        if (tok == JsonToken.END_ARRAY) {
                            this.state = State.FINISHED;
                            return null;
                        }
                        this.input.nextToken();
                        String currentName = this.input.getCurrentName();
                        if ("statement".equals(currentName)) {
                            statement = this.input.nextTextValue();
                            continue;
                        }
                        if (!"parameters".equals(currentName)) continue;
                        parameters = StatementDeserializer.readMap(this.input);
                    }
                    if (statement == null) {
                        this.addError(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "No statement provided."));
                        return null;
                    }
                    return new Statement(statement, parameters == null ? NO_PARAMETERS : parameters);
                }
                case FINISHED: {
                    return null;
                }
            }
            return null;
        }
        catch (JsonParseException e) {
            this.addError(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, "Unable to deserialize request: " + e.getMessage()));
            return null;
        }
        catch (IOException e) {
            this.addError(new Neo4jError(StatusCode.NETWORK_ERROR, "Input error while deserializing request.", e));
            return null;
        }
    }

    private static Map<String, Object> readMap(JsonParser input) throws IOException {
        return (Map)input.readValueAs(Map.class);
    }

    private void addError(Neo4jError error) {
        if (this.errors == null) {
            this.errors = new LinkedList<Neo4jError>();
        }
        this.errors.add(error);
    }

    private boolean beginsWithCorrectTokens() throws IOException {
        List<JsonToken> expectedTokens = Arrays.asList(JsonToken.START_OBJECT, JsonToken.FIELD_NAME, JsonToken.START_ARRAY);
        String expectedField = "statements";
        ArrayList<JsonToken> foundTokens = new ArrayList<JsonToken>();
        for (int i = 0; i < expectedTokens.size(); ++i) {
            JsonToken token = this.input.nextToken();
            if (i == 0 && token == null) {
                return false;
            }
            if (token == JsonToken.FIELD_NAME && !expectedField.equals(this.input.getText())) {
                this.addError(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, String.format("Unable to deserialize request, expected first field to be '%s', but was '%s'", expectedField, this.input.getText())));
                return false;
            }
            foundTokens.add(token);
        }
        if (!((Object)expectedTokens).equals(foundTokens)) {
            this.addError(new Neo4jError(StatusCode.INVALID_REQUEST_FORMAT, String.format("Unable to deserialize request, expected %s, found %s.", expectedTokens, foundTokens)));
            return false;
        }
        return true;
    }

    private static enum State {
        BEFORE_OUTER_ARRAY,
        IN_BODY,
        FINISHED;

    }
}

