/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.database.Database;
import org.neo4j.server.guard.GuardingRequestFilter;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.web.WebServer;

public class RESTApiModule
implements ServerModule {
    private static final Logger log = Logger.getLogger(RESTApiModule.class);
    private PluginManager plugins;
    private final Configuration config;
    private final WebServer webServer;
    private final Database database;
    private GuardingRequestFilter requestTimeLimitFilter;

    public RESTApiModule(WebServer webServer, Database database, Configuration config) {
        this.webServer = webServer;
        this.config = config;
        this.database = database;
    }

    @Override
    public void start(StringLogger logger) {
        try {
            URI restApiUri = this.restApiUri();
            this.webServer.addJAXRSPackages(this.getPackageNames(), restApiUri.toString(), null);
            this.loadPlugins(logger);
            this.setupRequestTimeLimit();
            log.info("Mounted REST API at [%s]", restApiUri.toString());
            if (logger != null) {
                logger.logMessage("Mounted REST API at: " + restApiUri.toString());
            }
        }
        catch (URISyntaxException e) {
            log.warn(e);
        }
    }

    private List<String> getPackageNames() {
        return JAXRSHelper.listFrom(new String[]{"org.neo4j.server.rest.web"});
    }

    @Override
    public void stop() {
        try {
            this.webServer.removeJAXRSPackages(this.getPackageNames(), this.restApiUri().toString());
            this.tearDownRequestTimeLimit();
            this.unloadPlugins();
        }
        catch (URISyntaxException e) {
            log.warn(e);
        }
    }

    private void tearDownRequestTimeLimit() {
        if (this.requestTimeLimitFilter != null) {
            this.webServer.removeFilter(this.requestTimeLimitFilter, "/*");
        }
    }

    private void setupRequestTimeLimit() {
        Integer limit = this.config.getInteger("org.neo4j.server.webserver.limit.executiontime", null);
        if (limit != null) {
            Guard guard = this.database.getGraph().getGuard();
            if (guard == null) {
                throw new RuntimeException("Unable to use guard, you have to enable guard in neo4j.properties");
            }
            this.requestTimeLimitFilter = new GuardingRequestFilter(guard, limit);
            this.webServer.addFilter(this.requestTimeLimitFilter, "/*");
        }
    }

    private URI restApiUri() throws URISyntaxException {
        return new URI(this.config.getString("org.neo4j.server.webadmin.data.uri", "/db/data"));
    }

    private void loadPlugins(StringLogger logger) {
        this.plugins = new PluginManager(this.config, logger);
    }

    private void unloadPlugins() {
    }

    public PluginManager getPlugins() {
        return this.plugins;
    }
}

