/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.neo4j.helpers.Pair;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.console.SessionFactoryImpl;
import org.neo4j.server.webadmin.rest.representations.ConsoleServiceRepresentation;

@Path(value="server/console")
public class ConsoleService
implements AdvertisableService {
    public static final String SERVICE_PATH = "server/console";
    private static final String SERVICE_NAME = "console";
    private static final Logger log = Logger.getLogger(ConsoleService.class);
    private final ConsoleSessionFactory sessionFactory;
    private final Database database;
    private final OutputFormat output;

    public ConsoleService(@Context Configuration config, @Context Database database, @Context HttpServletRequest req, @Context OutputFormat output, @Context CypherExecutor cypherExecutor) {
        this(new SessionFactoryImpl(req.getSession(true), config.getList("org.neo4j.server.manage.console_engines", Configurator.DEFAULT_MANAGEMENT_CONSOLE_ENGINES), cypherExecutor), database, output);
    }

    public ConsoleService(ConsoleSessionFactory sessionFactory, Database database, OutputFormat output) {
        this.sessionFactory = sessionFactory;
        this.database = database;
        this.output = output;
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public String getServerPath() {
        return SERVICE_PATH;
    }

    @GET
    public Response getServiceDefinition() {
        ConsoleServiceRepresentation result = new ConsoleServiceRepresentation(SERVICE_PATH, this.sessionFactory.supportedEngines());
        return this.output.ok((Representation)result);
    }

    @POST
    public Response exec(@Context InputFormat input, String data) {
        ScriptSession scriptSession;
        Map args;
        try {
            args = input.readMap(data, new String[0]);
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        if (!args.containsKey("command")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Expected command argument not present.").build();
        }
        try {
            scriptSession = this.getSession(args);
        }
        catch (IllegalArgumentException e) {
            return this.output.badRequest(e);
        }
        log.trace(scriptSession.toString(), new Object[0]);
        try {
            Pair<String, String> result = scriptSession.evaluate((String)args.get("command"));
            ArrayList<ValueRepresentation> list = new ArrayList<ValueRepresentation>(Arrays.asList(ValueRepresentation.string((String)((String)result.first())), ValueRepresentation.string((String)((String)result.other()))));
            return this.output.ok((Representation)new ListRepresentation(RepresentationType.STRING, list));
        }
        catch (Exception e) {
            ArrayList<ValueRepresentation> list = new ArrayList<ValueRepresentation>(Arrays.asList(ValueRepresentation.string((String)(e.getClass() + " : " + e.getMessage() + "\n")), ValueRepresentation.string(null)));
            return this.output.ok((Representation)new ListRepresentation(RepresentationType.STRING, list));
        }
    }

    private ScriptSession getSession(Map<String, Object> args) {
        return this.sessionFactory.createSession((String)args.get("engine"), this.database);
    }
}

