/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.representations.RrdDataRepresentation;
import org.neo4j.server.webadmin.rest.representations.ServiceDefinitionRepresentation;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;

@Path(value="server/monitor")
public class MonitorService
implements AdvertisableService {
    private final RrdDb rrdDb;
    private final OutputFormat output;
    public static final String ROOT_PATH = "server/monitor";
    public static final String DATA_PATH = "/fetch";
    public static final String DATA_FROM_PATH = "/fetch/{start}";
    public static final String DATA_SPAN_PATH = "/fetch/{start}/{stop}";
    public static final long MAX_TIMESPAN = TimeUnit.DAYS.toSeconds(1825L);
    public static final long DEFAULT_TIMESPAN = TimeUnit.DAYS.toSeconds(1L);

    @Override
    public String getName() {
        return "monitor";
    }

    @Override
    public String getServerPath() {
        return ROOT_PATH;
    }

    public MonitorService(@Context RrdDb rrdDb, @Context OutputFormat output) {
        this.rrdDb = rrdDb;
        this.output = output;
    }

    @GET
    public Response getServiceDefinition() {
        ServiceDefinitionRepresentation sdr = new ServiceDefinitionRepresentation(ROOT_PATH);
        sdr.resourceTemplate("data_from", DATA_FROM_PATH);
        sdr.resourceTemplate("data_period", DATA_SPAN_PATH);
        sdr.resourceUri("latest_data", DATA_PATH);
        return this.output.ok((Representation)sdr);
    }

    @GET
    @Path(value="/fetch")
    public Response getData() {
        long time = Util.getTime();
        return this.getData(time - DEFAULT_TIMESPAN, time);
    }

    @GET
    @Path(value="/fetch/{start}")
    public Response getData(@PathParam(value="start") long start) {
        return this.getData(start, Util.getTime());
    }

    @GET
    @Path(value="/fetch/{start}/{stop}")
    public Response getData(@PathParam(value="start") long start, @PathParam(value="stop") long stop) {
        if (start >= stop || stop - start > MAX_TIMESPAN) {
            return this.output.badRequest(new IllegalArgumentException(String.format("Start time must be before stop time, and the total time span can be no bigger than %dms. Time span was %dms.", MAX_TIMESPAN, stop - start)));
        }
        try {
            FetchRequest request = this.rrdDb.createFetchRequest(ConsolFun.AVERAGE, start, stop);
            return this.output.ok((Representation)new RrdDataRepresentation(request.fetchData()));
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }
}

