/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class SslCertificateFactory {
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String KEY_ENCRYPTION = "RSA";

    public SslCertificateFactory() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void createSelfSignedCertificate(File certificatePath, File privateKeyPath, String hostName) {
        FileOutputStream fos = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ENCRYPTION);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509V3CertificateGenerator certGenertor = new X509V3CertificateGenerator();
            certGenertor.setSerialNumber(BigInteger.valueOf(new SecureRandom().nextInt()).abs());
            certGenertor.setIssuerDN((X509Name)new X509Principal("CN=" + hostName + ", OU=None, O=None L=None, C=None"));
            certGenertor.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
            certGenertor.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
            certGenertor.setSubjectDN((X509Name)new X509Principal("CN=" + hostName + ", OU=None, O=None L=None, C=None"));
            certGenertor.setPublicKey(keyPair.getPublic());
            certGenertor.setSignatureAlgorithm("MD5WithRSAEncryption");
            X509Certificate certificate = certGenertor.generate(keyPair.getPrivate(), "BC");
            this.ensureFolderExists(certificatePath.getParentFile());
            this.ensureFolderExists(privateKeyPath.getParentFile());
            fos = new FileOutputStream(certificatePath);
            fos.write(certificate.getEncoded());
            fos.close();
            fos = new FileOutputStream(privateKeyPath);
            fos.write(keyPair.getPrivate().getEncoded());
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create self signed SSL certificate, please see nested exception.", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate loadCertificate(File certFile) throws CertificateException, FileNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(certFile);
            Certificate certificate = CertificateFactory.getInstance(CERTIFICATE_TYPE).generateCertificate(fis);
            return certificate;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public PrivateKey loadPrivateKey(File privateKeyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        FilterInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(privateKeyFile);
            dis = new DataInputStream(fis);
            byte[] keyBytes = new byte[(int)privateKeyFile.length()];
            ((DataInputStream)dis).readFully(keyBytes);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey privateKey = KeyFactory.getInstance(KEY_ENCRYPTION).generatePrivate(keySpec);
            return privateKey;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Could not find private key file to use for SSL support, see nested exception.", e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void ensureFolderExists(File path) {
        if (!path.exists()) {
            path.mkdirs();
        }
    }
}

