/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Map;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.ObjectToRepresentationConverter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;

public class ServerListRepresentation
extends ListRepresentation {
    public ServerListRepresentation(RepresentationType type, Iterable<? extends Representation> content) {
        super(type, content);
    }

    protected void serialize(ListSerializer serializer) {
        for (Representation val : this.content) {
            if (val instanceof Number || val instanceof Integer) {
                serializer.addNumber((Number)val);
                continue;
            }
            if (val instanceof String) {
                serializer.addString((String)val);
                continue;
            }
            if (val instanceof Iterable) {
                serializer.addList(ObjectToRepresentationConverter.getListRepresentation((Iterable)val));
                continue;
            }
            if (val instanceof Map) {
                serializer.addMapping(ObjectToRepresentationConverter.getMapRepresentation((Map)val));
                continue;
            }
            if (val instanceof MappingRepresentation) {
                serializer.addMapping((MappingRepresentation)val);
                continue;
            }
            if (val instanceof Representation) {
                val.addTo(serializer);
                continue;
            }
            serializer.addString(val.toString());
        }
    }
}

