/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.neo4j.server.preflight.PreflightTask;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EnsurePreparedForHttpLogging
implements PreflightTask {
    private String failureMessage = "";
    private Configuration config;

    public EnsurePreparedForHttpLogging(Configuration config) {
        this.config = config;
    }

    @Override
    public boolean run() {
        boolean enabled = this.config.getBoolean("org.neo4j.server.http.log.enabled", false);
        if (!enabled) {
            return true;
        }
        File logLocation = this.extractLogLocationFromConfig(this.config.getString("org.neo4j.server.http.log.config"));
        if (logLocation != null) {
            return this.validateFileBasedLoggingConfig(logLocation);
        }
        return true;
    }

    private boolean validateFileBasedLoggingConfig(File logLocation) {
        try {
            FileUtils.forceMkdir((File)logLocation);
        }
        catch (IOException e) {
            this.failureMessage = String.format("HTTP log directory [%s] does not exist", logLocation.getAbsolutePath());
            return false;
        }
        if (!logLocation.exists()) {
            this.failureMessage = String.format("HTTP log directory [%s] cannot be created", logLocation.getAbsolutePath());
            return false;
        }
        if (!logLocation.canWrite()) {
            this.failureMessage = String.format("HTTP log directory [%s] is not writable", logLocation.getAbsolutePath());
            return false;
        }
        return true;
    }

    private File extractLogLocationFromConfig(String configLocation) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            File file = new File(configLocation);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            Node node = doc.getElementsByTagName("file").item(0);
            return new File(node.getTextContent()).getParentFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }
}

