/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.List;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class DiscoveryModule
implements ServerModule {
    private static final Logger log = Logger.getLogger(DiscoveryModule.class);
    private static final String ROOT_PATH = "/";
    private final WebServer webServer;

    public DiscoveryModule(WebServer webServer) {
        this.webServer = webServer;
    }

    @Override
    public void start(StringLogger logger) {
        this.webServer.addJAXRSPackages(this.getPackageNames(), ROOT_PATH, null);
        log.info("Mounted discovery module at [%s]", ROOT_PATH);
        if (logger != null) {
            logger.logMessage("Mounted discovery module (org.neo4j.server.rest.discovery) at: /");
        }
    }

    private List<String> getPackageNames() {
        return JAXRSHelper.listFrom(new String[]{"org.neo4j.server.rest.discovery"});
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSPackages(this.getPackageNames(), ROOT_PATH);
    }
}

