/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.rest.web.PropertyValueException;

public class PropertySettingStrategy {
    private final GraphDatabaseAPI db;

    public PropertySettingStrategy(GraphDatabaseAPI db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllProperties(PropertyContainer entity, Map<String, Object> properties) throws PropertyValueException {
        HashMap<String, Object> propsToSet = properties == null ? new HashMap<String, Object>() : properties;
        Transaction tx = this.db.beginTx();
        try {
            this.setProperties(entity, properties);
            this.ensureHasOnlyTheseProperties(entity, propsToSet.keySet());
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private void ensureHasOnlyTheseProperties(PropertyContainer entity, Set<String> propertiesThatShouldExist) {
        for (String entityPropertyKey : entity.getPropertyKeys()) {
            if (propertiesThatShouldExist.contains(entityPropertyKey)) continue;
            entity.removeProperty(entityPropertyKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(PropertyContainer entity, Map<String, Object> properties) throws PropertyValueException {
        if (properties != null) {
            Transaction tx = this.db.beginTx();
            try {
                for (Map.Entry<String, Object> property : properties.entrySet()) {
                    this.setProperty(entity, property.getKey(), property.getValue());
                }
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(PropertyContainer entity, String key, Object value) throws PropertyValueException {
        if (value instanceof Collection) {
            if (((Collection)value).size() == 0) {
                Object currentValue = entity.getProperty(key, null);
                if (currentValue == null || !currentValue.getClass().isArray()) throw new PropertyValueException("Unable to set property '" + key + "' to an empty array, " + "because, since there are no values of any type in it, " + "and no pre-existing collection to infer type from, it is not possible " + "to determine what type of array to store.");
                if (Array.getLength(currentValue) == 0) {
                    return;
                }
                value = this.emptyArrayOfType(currentValue.getClass().getComponentType());
            } else {
                value = this.convertToNativeArray((Collection)value);
            }
        }
        Transaction tx = this.db.beginTx();
        try {
            entity.setProperty(key, value);
            tx.success();
            return;
        }
        catch (IllegalArgumentException e) {
            throw new PropertyValueException(key, value);
        }
        finally {
            tx.finish();
        }
    }

    private Object emptyArrayOfType(Class<?> cls) throws PropertyValueException {
        return Array.newInstance(cls, 0);
    }

    private Object convertToNativeArray(Collection<?> collection) {
        Object[] array = null;
        Iterator<?> objects = collection.iterator();
        int i = 0;
        while (objects.hasNext()) {
            Object object = objects.next();
            if (array == null) {
                array = (Object[])Array.newInstance(object.getClass(), collection.size());
            }
            array[i] = object;
            ++i;
        }
        return array;
    }
}

