/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.shell.ShellSettings;

public class CommunityDatabase
extends Database {
    protected final Configuration serverConfig;

    public CommunityDatabase(Configuration serverConfig) {
        this.serverConfig = serverConfig;
    }

    public CommunityDatabase(Configuration serverConfig, Map<String, String> neo4jProperties) {
        this.serverConfig = serverConfig;
    }

    @Override
    public void start() throws Throwable {
        try {
            this.graph = (AbstractGraphDatabase)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.serverConfig.getString("org.neo4j.server.database.location", "data/graph.db")).setConfig(this.loadNeo4jProperties()).newGraphDatabase();
            log.info("Successfully started database", new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed to start database.", e);
            throw e;
        }
    }

    @Override
    public void stop() throws Throwable {
        try {
            if (this.graph != null) {
                this.graph.shutdown();
                this.graph = null;
                log.info("Successfully stopped database", new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Database did not stop cleanly. Reason [%s]", e.getMessage());
            throw e;
        }
    }

    protected Map<String, String> loadNeo4jProperties() {
        HashMap<String, String> neo4jProperties;
        try {
            String path = this.serverConfig.getString("org.neo4j.server.db.tuning.properties", "");
            neo4jProperties = MapUtil.load((File)new File(path));
            log.info("Loaded neo4j tuning properties from " + path, new Object[0]);
        }
        catch (IOException e) {
            log.warn("Unable to load database tuning properties, using defaults.", e);
            neo4jProperties = new HashMap<String, String>();
        }
        this.putIfAbsent(neo4jProperties, ShellSettings.remote_shell_enabled.name(), "true");
        this.putIfAbsent(neo4jProperties, GraphDatabaseSettings.keep_logical_logs.name(), "true");
        try {
            neo4jProperties.put(UdcSettings.udc_source.name(), "server");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return neo4jProperties;
    }

    private void putIfAbsent(Map<String, String> databaseProperties, String configKey, String configValue) {
        if (databaseProperties.get(configKey) == null) {
            databaseProperties.put(configKey, configValue);
        }
    }
}

