/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.preflight.PreflightTask;

public class PreFlightTasks {
    private final PreflightTask[] tasks;
    private final ConsoleLogger log;
    private PreflightTask failedTask = null;

    public PreFlightTasks(Logging logging, PreflightTask ... tasks) {
        this.tasks = tasks;
        this.log = logging.getConsoleLog(this.getClass());
    }

    public boolean run() {
        if (this.tasks == null || this.tasks.length < 1) {
            return true;
        }
        for (PreflightTask r : this.tasks) {
            if (r.run()) continue;
            this.log.error(r.getFailureMessage());
            this.failedTask = r;
            return false;
        }
        return true;
    }

    public PreflightTask failedTask() {
        return this.failedTask;
    }
}

