/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.modules.ExtensionInitializer;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.web.WebServer;

public class ThirdPartyJAXRSModule
implements ServerModule {
    private final Configurator configurator;
    private final WebServer webServer;
    private final ExtensionInitializer extensionInitializer;
    private List<ThirdPartyJaxRsPackage> packages;
    private final ConsoleLogger log;

    public ThirdPartyJAXRSModule(WebServer webServer, Configurator configurator, Logging logging, NeoServer neoServer) {
        this.webServer = webServer;
        this.configurator = configurator;
        this.log = logging.getConsoleLog(this.getClass());
        this.extensionInitializer = new ExtensionInitializer(neoServer);
    }

    @Override
    public void start() {
        this.packages = this.configurator.getThirdpartyJaxRsPackages();
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            List<String> packageNames = this.packagesFor(tpp);
            Collection<Injectable<?>> injectables = this.extensionInitializer.initializePackages(packageNames);
            this.webServer.addJAXRSPackages(packageNames, tpp.getMountPoint(), injectables);
            this.log.log("Mounted third-party JAX-RS package [%s] at [%s]", new Object[]{tpp.getPackageName(), tpp.getMountPoint()});
        }
    }

    private List<String> packagesFor(ThirdPartyJaxRsPackage tpp) {
        return JAXRSHelper.listFrom(tpp.getPackageName());
    }

    @Override
    public void stop() {
        if (this.packages == null) {
            return;
        }
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            this.webServer.removeJAXRSPackages(this.packagesFor(tpp), tpp.getMountPoint());
        }
        this.extensionInitializer.stop();
    }
}

