/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.database.Database;
import org.neo4j.server.guard.GuardingRequestFilter;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.web.BatchOperationService;
import org.neo4j.server.rest.web.CypherService;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.server.rest.web.ExtensionService;
import org.neo4j.server.rest.web.ResourcesService;
import org.neo4j.server.rest.web.RestfulGraphDatabase;
import org.neo4j.server.web.WebServer;

public class RESTApiModule
implements ServerModule {
    private PluginManager plugins;
    private final Configuration config;
    private final WebServer webServer;
    private final Database database;
    private GuardingRequestFilter requestTimeLimitFilter;
    private final ConsoleLogger log;
    private final Logging logging;

    public RESTApiModule(WebServer webServer, Database database, Configuration config, Logging logging) {
        this.webServer = webServer;
        this.config = config;
        this.database = database;
        this.logging = logging;
        this.log = logging.getConsoleLog(this.getClass());
    }

    @Override
    public void start() {
        try {
            URI restApiUri = this.restApiUri();
            this.webServer.addJAXRSClasses(this.getClassNames(), restApiUri.toString(), null);
            this.loadPlugins();
            this.setupRequestTimeLimit();
            this.log.log("Mounted REST API at [%s]", new Object[]{restApiUri.toString()});
        }
        catch (URISyntaxException e) {
            this.log.warn("Unable to mount REST API", (Throwable)e);
        }
    }

    private List<String> getClassNames() {
        return JAXRSHelper.listFrom(RestfulGraphDatabase.class.getName(), CypherService.class.getName(), DatabaseMetadataService.class.getName(), ExtensionService.class.getName(), ResourcesService.class.getName(), BatchOperationService.class.getName());
    }

    @Override
    public void stop() {
        try {
            this.webServer.removeJAXRSClasses(this.getClassNames(), this.restApiUri().toString());
            this.tearDownRequestTimeLimit();
            this.unloadPlugins();
        }
        catch (URISyntaxException e) {
            this.log.warn("Unable to unmount REST API", (Throwable)e);
        }
    }

    private void tearDownRequestTimeLimit() {
        if (this.requestTimeLimitFilter != null) {
            this.webServer.removeFilter(this.requestTimeLimitFilter, "/*");
        }
    }

    private void setupRequestTimeLimit() {
        Integer limit = this.config.getInteger("org.neo4j.server.webserver.limit.executiontime", null);
        if (limit != null) {
            Guard guard = this.database.getGraph().getGuard();
            if (guard == null) {
                throw new RuntimeException("Unable to use guard, you have to enable guard in neo4j.properties");
            }
            this.requestTimeLimitFilter = new GuardingRequestFilter(guard, limit);
            this.webServer.addFilter(this.requestTimeLimitFilter, "/*");
        }
    }

    private URI restApiUri() throws URISyntaxException {
        return new URI(this.config.getString("org.neo4j.server.webadmin.data.uri", "/db/data"));
    }

    private void loadPlugins() {
        this.plugins = new PluginManager(this.config, this.logging);
    }

    private void unloadPlugins() {
    }

    public PluginManager getPlugins() {
        return this.plugins;
    }
}

