/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration.validation;

import java.util.ArrayList;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.server.configuration.validation.RuleFailedException;
import org.neo4j.server.configuration.validation.ValidationRule;

public class Validator {
    private final ArrayList<ValidationRule> validationRules = new ArrayList();
    public static final Validator NO_VALIDATION = new Validator(new ValidationRule[0]);

    public Validator(ValidationRule ... rules) {
        if (rules == null) {
            return;
        }
        for (ValidationRule r : rules) {
            this.validationRules.add(r);
        }
    }

    public boolean validate(Configuration configuration, ConsoleLogger log) {
        for (ValidationRule vr : this.validationRules) {
            try {
                vr.validate(configuration);
            }
            catch (RuleFailedException rfe) {
                log.warn(rfe.getMessage());
                return false;
            }
        }
        return true;
    }
}

