/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.InvalidServerConfigurationException;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;

public class PropertyFileConfigurator
extends Configurator.Adapter {
    private static final String NEO4J_PROPERTIES_FILENAME = "neo4j.properties";
    private final CompositeConfiguration serverConfiguration = new CompositeConfiguration();
    private File propertyFileDirectory;
    private final Validator validator = new Validator(new ValidationRule[0]);
    private Map<String, String> databaseTuningProperties = null;

    public PropertyFileConfigurator(File propertiesFile) {
        this(Validator.NO_VALIDATION, propertiesFile, ConsoleLogger.DEV_NULL);
    }

    public PropertyFileConfigurator(Validator v, File propertiesFile, ConsoleLogger log) {
        if (propertiesFile == null) {
            propertiesFile = new File(System.getProperty("org.neo4j.server.properties"));
        }
        try {
            this.propertyFileDirectory = propertiesFile.getParentFile();
            this.loadPropertiesConfig(propertiesFile, log);
            this.loadDatabaseTuningProperties(propertiesFile, log);
            this.normalizeUris();
            this.ensureRelativeUris();
            if (v != null) {
                v.validate(this.configuration(), log);
            }
        }
        catch (ConfigurationException ce) {
            log.warn("Invalid configuration", (Throwable)ce);
        }
    }

    @Override
    public Configuration configuration() {
        return this.serverConfiguration == null ? new SystemConfiguration() : this.serverConfiguration;
    }

    private void loadDatabaseTuningProperties(File configFile, ConsoleLogger log) throws ConfigurationException {
        File databaseTuningPropertyFile;
        String databaseTuningPropertyFileLocation = this.serverConfiguration.getString("org.neo4j.server.db.tuning.properties");
        if (databaseTuningPropertyFileLocation == null) {
            if (this.propertyFileDirectoryContainsDBTuningFile()) {
                databaseTuningPropertyFileLocation = new File(this.propertyFileDirectory, NEO4J_PROPERTIES_FILENAME).getAbsolutePath();
                log.log("No database tuning file explicitly set, defaulting to [%s]", new Object[]{databaseTuningPropertyFileLocation});
            } else {
                log.log("No database tuning properties (org.neo4j.server.db.tuning.properties) found in [%s], using defaults.", new Object[]{databaseTuningPropertyFileLocation});
                return;
            }
        }
        if (!(databaseTuningPropertyFile = new File(databaseTuningPropertyFileLocation)).exists()) {
            log.warn("The specified file for database performance tuning properties [%s] does not exist.", new Object[]{databaseTuningPropertyFileLocation});
            return;
        }
        try {
            this.databaseTuningProperties = MapUtil.load((File)databaseTuningPropertyFile);
        }
        catch (IOException e) {
            this.databaseTuningProperties = new HashMap<String, String>();
        }
    }

    private void loadPropertiesConfig(File configFile, ConsoleLogger log) throws ConfigurationException {
        PropertiesConfiguration propertiesConfig = new PropertiesConfiguration(configFile);
        if (!this.validator.validate((Configuration)propertiesConfig, log)) {
            String failed = String.format("Error processing [%s], configuration file has failed validation.", configFile.getAbsolutePath());
            log.error(failed);
            throw new InvalidServerConfigurationException(failed);
        }
        this.serverConfiguration.addConfiguration((Configuration)propertiesConfig);
    }

    private void normalizeUris() {
        try {
            for (String key : new String[]{"org.neo4j.server.webadmin.management.uri", "org.neo4j.server.webadmin.data.uri"}) {
                if (!this.configuration().containsKey(key)) continue;
                URI normalizedUri = new URI((String)this.configuration().getProperty(key)).normalize();
                this.configuration().clearProperty(key);
                this.configuration().addProperty(key, (Object)normalizedUri.toString());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureRelativeUris() {
        try {
            for (String key : new String[]{"org.neo4j.server.webadmin.management.uri", "org.neo4j.server.webadmin.data.uri"}) {
                if (!this.configuration().containsKey(key)) continue;
                String path = new URI((String)this.configuration().getProperty(key)).getPath();
                this.configuration().clearProperty(key);
                this.configuration().addProperty(key, (Object)path);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean propertyFileDirectoryContainsDBTuningFile() {
        File[] neo4jPropertyFiles = this.propertyFileDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().equals(PropertyFileConfigurator.NEO4J_PROPERTIES_FILENAME);
            }
        });
        return neo4jPropertyFiles != null && neo4jPropertyFiles.length == 1;
    }

    public File getPropertyFileDirectory() {
        return this.propertyFileDirectory;
    }

    @Override
    public Map<String, String> getDatabaseTuningProperties() {
        return this.databaseTuningProperties == null ? new HashMap() : this.databaseTuningProperties;
    }

    @Override
    public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages() {
        ArrayList<ThirdPartyJaxRsPackage> thirdPartyPackages = new ArrayList<ThirdPartyJaxRsPackage>();
        List packagesAndMountpoints = this.configuration().getList("org.neo4j.server.thirdparty_jaxrs_classes");
        for (String packageAndMoutpoint : packagesAndMountpoints) {
            String[] parts = packageAndMoutpoint.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("config for org.neo4j.server.thirdparty_jaxrs_classes is wrong: " + packageAndMoutpoint);
            }
            String pkg = parts[0];
            String mountPoint = parts[1];
            thirdPartyPackages.add(new ThirdPartyJaxRsPackage(pkg, mountPoint));
        }
        return thirdPartyPackages;
    }
}

