/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;

public class WrappingNeoServer
extends CommunityNeoServer {
    private final GraphDatabaseAPI db;

    public WrappingNeoServer(GraphDatabaseAPI db) {
        this(db, new ServerConfigurator(db));
    }

    public WrappingNeoServer(GraphDatabaseAPI db, Configurator configurator) {
        super((Logging)db.getDependencyResolver().resolveDependency(Logging.class));
        this.configurator = configurator;
        this.db = db;
        this.init();
    }

    @Override
    protected PreFlightTasks createPreflightTasks() {
        return new PreFlightTasks(this.logging, new PreflightTask[0]);
    }

    @Override
    protected Database createDatabase() {
        return new WrappingDatabase((AbstractGraphDatabase)this.db);
    }
}

