/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CommunityDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.DiscoveryModule;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.SecurityRulesModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.StatisticModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.modules.WebAdminModule;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;
import org.neo4j.server.preflight.PerformUpgradeIfNecessary;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.web.Jetty6WebServer;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.webadmin.rest.AdvertisableService;
import org.neo4j.server.webadmin.rest.JmxService;
import org.neo4j.server.webadmin.rest.MonitorService;
import org.neo4j.server.webadmin.rest.console.ConsoleService;

public class CommunityNeoServer
extends AbstractNeoServer {
    public CommunityNeoServer(Logging logging) {
        super(logging);
    }

    public CommunityNeoServer(Configurator configurator, Logging logging) {
        super(logging);
        this.configurator = configurator;
        this.init();
    }

    @Override
    protected PreFlightTasks createPreflightTasks() {
        return new PreFlightTasks(this.logging, new EnsurePreparedForHttpLogging(this.configurator.configuration()), new PerformUpgradeIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out, this.logging), new PerformRecoveryIfNecessary(this.getConfiguration(), this.configurator.getDatabaseTuningProperties(), System.out, this.logging));
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        return Arrays.asList(new DiscoveryModule(this.webServer, this.logging), new RESTApiModule(this.webServer, this.database, this.configurator.configuration(), this.logging), new ManagementApiModule(this.webServer, this.configurator.configuration(), this.logging), new ThirdPartyJAXRSModule(this.webServer, this.configurator, this.logging, this), new WebAdminModule(this.webServer, this.configurator.configuration(), this.logging, this.database), new StatisticModule(this.webServer, this.statisticsCollector, this.configurator.configuration()), new SecurityRulesModule(this.webServer, this.configurator.configuration(), this.logging));
    }

    @Override
    protected Database createDatabase() {
        return new CommunityDatabase(this.configurator, this.logging);
    }

    @Override
    protected WebServer createWebServer() {
        return new Jetty6WebServer(this.logging);
    }

    @Override
    public Iterable<AdvertisableService> getServices() {
        ArrayList<AdvertisableService> toReturn = new ArrayList<AdvertisableService>(3);
        toReturn.add(new ConsoleService(null, new Database(this.logging), null));
        toReturn.add(new JmxService(null, null));
        toReturn.add(new MonitorService(null, null));
        return toReturn;
    }
}

