/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.BufferingConsoleLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.DefaultLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.Validator;

public abstract class Bootstrapper {
    public static final Integer OK = 0;
    public static final Integer WEB_SERVER_STARTUP_ERROR_CODE = 1;
    public static final Integer GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    protected final LifeSupport life = new LifeSupport();
    protected NeoServer server;
    protected Configurator configurator;
    private Thread shutdownHook;
    protected Logging logging;
    private ConsoleLogger log;

    public static void main(String[] args) {
        Bootstrapper bootstrapper = Bootstrapper.loadMostDerivedBootstrapper();
        Integer exit = bootstrapper.start(args);
        if (exit != 0) {
            System.exit(exit);
        }
    }

    public static Bootstrapper loadMostDerivedBootstrapper() {
        Bootstrapper winner = new CommunityBootstrapper();
        for (Bootstrapper candidate : Service.load(Bootstrapper.class)) {
            if (!candidate.isMoreDerivedThan(winner)) continue;
            winner = candidate;
        }
        return winner;
    }

    public void controlEvent(int arg) {
    }

    public Integer start() {
        return this.start(new String[0]);
    }

    public Integer start(String[] args) {
        try {
            BufferingConsoleLogger consoleBuffer = new BufferingConsoleLogger();
            this.configurator = this.createConfigurator((ConsoleLogger)consoleBuffer);
            this.logging = this.createLogging(this.configurator);
            this.log = this.logging.getConsoleLog(this.getClass());
            consoleBuffer.replayInto(this.log);
            this.life.start();
            this.checkCompatibility();
            this.server = this.createNeoServer();
            this.server.start();
            this.addShutdownHook();
            return OK;
        }
        catch (TransactionFailureException tfe) {
            this.log.error(String.format("Failed to start Neo Server on port [%d], because ", this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474)) + (Object)((Object)tfe) + ". Another process may be using database location " + this.server.getDatabase().getLocation(), (Throwable)tfe);
            return GRAPH_DATABASE_STARTUP_ERROR_CODE;
        }
        catch (IllegalArgumentException e) {
            this.log.error(String.format("Failed to start Neo Server on port [%s]", this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474)), (Throwable)e);
            return WEB_SERVER_STARTUP_ERROR_CODE;
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to start Neo Server on port [%s]", this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474)), (Throwable)e);
            return WEB_SERVER_STARTUP_ERROR_CODE;
        }
    }

    private Logging createLogging(Configurator configurator) {
        Config config = new Config(configurator.getDatabaseTuningProperties());
        return (Logging)this.life.add((Object)DefaultLogging.createDefaultLogging((Config)config));
    }

    private void checkCompatibility() {
        new JvmChecker(this.logging.getMessagesLog(JvmChecker.class), new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
    }

    protected abstract NeoServer createNeoServer();

    public void stop() {
        this.stop(0);
    }

    public int stop(int stopArg) {
        String location = "unknown location";
        try {
            if (this.server != null) {
                this.server.stop();
            }
            this.log.log("Successfully shutdown Neo Server on port [%d], database [%s]", new Object[]{this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474), location});
            this.removeShutdownHook();
            this.life.shutdown();
            return 0;
        }
        catch (Exception e) {
            this.log.error("Failed to cleanly shutdown Neo Server on port [%d], database [%s]. Reason [%s] ", new Object[]{this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474), location, e.getMessage(), e});
            return 1;
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null && !Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
            this.log.warn("Unable to remove shutdown hook");
        }
    }

    public NeoServer getServer() {
        return this.server;
    }

    protected void addShutdownHook() {
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                Bootstrapper.this.log.log("Neo4j Server shutdown initiated by request");
                if (Bootstrapper.this.server != null) {
                    Bootstrapper.this.server.stop();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected Configurator createConfigurator(ConsoleLogger log) {
        File configFile = new File(System.getProperty("org.neo4j.server.properties", Configurator.DEFAULT_CONFIG_DIR));
        return new PropertyFileConfigurator(new Validator(new DatabaseLocationMustBeSpecifiedRule()), configFile, log);
    }

    protected boolean isMoreDerivedThan(Bootstrapper other) {
        return other.getClass().isAssignableFrom(this.getClass());
    }
}

