/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.batch;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.server.rest.domain.JsonHelper;

public class BatchOperationResults {
    private static final String CLOSING_BRACKET = "]";
    private static final String OPENING_BRACKET = "[";
    private static final String OPENING_CURLY = "{";
    private static final String CLOSING_CURLY = "}";
    private static final String COMMA = ",";
    private StringWriter results = new StringWriter();
    private boolean firstResult = true;
    private Map<Integer, String> locations = new HashMap<Integer, String>();

    public BatchOperationResults() {
        this.results.append(OPENING_BRACKET);
    }

    public void addOperationResult(String from, Integer id, String body, String location) {
        if (this.firstResult) {
            this.firstResult = false;
        } else {
            this.results.append(',');
        }
        this.results.append(OPENING_CURLY);
        if (id != null) {
            this.results.append("\"id\":").append(id.toString()).append(COMMA);
        }
        System.out.println("DONE:" + id);
        if (location != null) {
            System.out.println("Got Location:" + location);
            this.locations.put(id, location);
            this.results.append("\"location\":").append(JsonHelper.createJsonFrom(location)).append(COMMA);
        }
        if (body != null && body.length() != 0) {
            this.results.append("\"body\":").append(body).append(COMMA);
        }
        this.results.append("\"from\":").append(JsonHelper.createJsonFrom(from));
        this.results.append(CLOSING_CURLY);
    }

    public Map<Integer, String> getLocations() {
        return this.locations;
    }

    public String toJSON() {
        this.results.append(CLOSING_BRACKET);
        return this.results.toString();
    }
}

