/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.server.database.Database;
import org.neo4j.tooling.GlobalGraphOperations;

@Path(value="/relationship/types")
public class DatabaseMetadataService {
    private final Database database;

    public DatabaseMetadataService(@Context Database database) {
        this.database = database;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRelationshipTypes() {
        Iterable relationshipTypes = GlobalGraphOperations.at((GraphDatabaseService)this.database.getGraph()).getAllRelationshipTypes();
        return Response.ok().type("application/json").entity((Object)this.generateJsonRepresentation(relationshipTypes)).build();
    }

    private String generateJsonRepresentation(Iterable<RelationshipType> relationshipTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (RelationshipType rt : relationshipTypes) {
            sb.append("\"");
            sb.append(rt.name());
            sb.append("\",");
        }
        sb.append("]");
        return sb.toString().replaceAll(",]", "]");
    }
}

