/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.plugins.BadPluginInvocationException;
import org.neo4j.server.plugins.DataExtractor;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.ParameterDescriptionConsumer;
import org.neo4j.server.plugins.ParameterList;
import org.neo4j.server.plugins.PluginInvocationFailureException;
import org.neo4j.server.plugins.PluginPoint;
import org.neo4j.server.plugins.ResultConverter;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.Representation;

class PluginMethod
extends PluginPoint {
    private final ServerPlugin plugin;
    private final Method method;
    private final DataExtractor[] extractors;
    private final ResultConverter result;

    PluginMethod(String name, Class<?> discovery, ServerPlugin plugin, ResultConverter result, Method method, DataExtractor[] extractors, Description description) {
        super(discovery, name, description == null ? "" : description.value());
        this.plugin = plugin;
        this.result = result;
        this.method = method;
        this.extractors = extractors;
    }

    public Representation invoke(GraphDatabaseAPI graphDb, Object source, ParameterList params) throws BadPluginInvocationException, PluginInvocationFailureException, BadInputException {
        Object[] arguments = new Object[this.extractors.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.extractors[i].extract(graphDb, source, params);
        }
        try {
            Object returned = this.method.invoke((Object)this.plugin, arguments);
            if (returned == null) {
                return Representation.emptyRepresentation();
            }
            return this.result.convert(returned);
        }
        catch (InvocationTargetException exc) {
            Throwable targetExc = exc.getTargetException();
            for (Class<?> excType : this.method.getExceptionTypes()) {
                if (!excType.isInstance(targetExc)) continue;
                throw new BadPluginInvocationException(targetExc);
            }
            throw new PluginInvocationFailureException(targetExc);
        }
        catch (IllegalArgumentException e) {
            throw new PluginInvocationFailureException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginInvocationFailureException((Throwable)e);
        }
    }

    protected void describeParameters(ParameterDescriptionConsumer consumer) {
        for (DataExtractor extractor : this.extractors) {
            extractor.describe(consumer);
        }
    }
}

