/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.server.rest.paging.Clock;
import org.neo4j.server.rest.paging.Lease;
import org.neo4j.server.rest.paging.LeaseAlreadyExpiredException;
import org.neo4j.server.rest.paging.PagedTraverser;

public class LeaseManager {
    private Clock clock;
    private Map<String, Lease> leases = new ConcurrentHashMap<String, Lease>();

    public LeaseManager(Clock clock) {
        this.clock = clock;
    }

    public Lease createLease(long seconds, PagedTraverser leasedTraverser) throws LeaseAlreadyExpiredException {
        if (seconds < 1L) {
            return null;
        }
        Lease lease = new Lease(leasedTraverser, seconds, this.clock);
        this.leases.put(lease.getId(), lease);
        return lease;
    }

    public Lease getLeaseById(String id) {
        this.pruneOldLeasesByNaivelyIteratingThroughAllOfThem();
        Lease lease = this.leases.get(id);
        if (lease != null) {
            lease.renew();
        }
        return lease;
    }

    private void pruneOldLeasesByNaivelyIteratingThroughAllOfThem() {
        for (String key : this.leases.keySet()) {
            try {
                Lease lease = this.leases.get(key);
                if (lease.getStartTime() + lease.getPeriod() >= this.clock.currentTimeInMilliseconds()) continue;
                this.remove(key);
            }
            catch (Exception exception) {}
        }
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void remove(String key) {
        if (this.leases.containsKey(key)) {
            this.leases.remove(key);
        }
    }
}

