/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import ch.qos.logback.access.jetty.RequestLogImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.MovedContextHandler;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.server.NeoServer;
import org.neo4j.server.guard.GuardingRequestFilter;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.rest.security.SecurityFilter;
import org.neo4j.server.rest.security.SecurityRule;
import org.neo4j.server.rest.security.UriPathWildcardMatcher;
import org.neo4j.server.rest.web.AllowAjaxFilter;
import org.neo4j.server.rest.web.CollectUserAgentFilter;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslSocketConnectorFactory;
import org.neo4j.server.web.JettyLifeCycleListenerAdapter;
import org.neo4j.server.web.NeoServletContainer;
import org.neo4j.server.web.WebServer;

public class Jetty6WebServer
implements WebServer {
    private static final int DEFAULT_HTTPS_PORT = 7473;
    public static final Logger log = Logger.getLogger(Jetty6WebServer.class);
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_ADDRESS = "0.0.0.0";
    private Server jetty;
    private int jettyHttpPort = 80;
    private int jettyHttpsPort = 7473;
    private String jettyAddr = "0.0.0.0";
    private final HashMap<String, String> staticContent = new HashMap();
    private final HashMap<String, ServletHolder> jaxRSPackages = new HashMap();
    private final List<FilterDefinition> filters = new ArrayList<FilterDefinition>();
    private NeoServer server;
    private int jettyMaxThreads = this.tenThreadsPerProcessor();
    private boolean httpsEnabled = false;
    private KeyStoreInformation httpsCertificateInformation = null;
    private final SslSocketConnectorFactory sslSocketFactory = new SslSocketConnectorFactory();
    private File requestLoggingConfiguration;

    @Override
    public void init() {
    }

    @Override
    public void start() {
        if (this.jetty == null) {
            this.jetty = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(this.jettyHttpPort);
            connector.setHost(this.jettyAddr);
            this.jetty.addConnector((Connector)connector);
            if (this.httpsEnabled) {
                if (this.httpsCertificateInformation != null) {
                    this.jetty.addConnector((Connector)this.sslSocketFactory.createConnector(this.httpsCertificateInformation, this.jettyAddr, this.jettyHttpsPort));
                } else {
                    throw new RuntimeException("HTTPS set to enabled, but no HTTPS configuration provided.");
                }
            }
            this.jetty.setThreadPool((ThreadPool)new QueuedThreadPool(this.jettyMaxThreads));
        }
        MovedContextHandler redirector = new MovedContextHandler();
        this.jetty.addHandler((Handler)redirector);
        this.loadAllMounts();
        this.startJetty();
    }

    @Override
    public void stop() {
        try {
            this.jetty.stop();
            this.jetty.join();
            this.jetty = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPort(int portNo) {
        this.jettyHttpPort = portNo;
    }

    @Override
    public void setAddress(String addr) {
        this.jettyAddr = addr;
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this.jettyMaxThreads = maxThreads;
    }

    @Override
    public void addJAXRSPackages(List<String> packageNames, String mountPoint) {
        mountPoint = this.ensureRelativeUri(mountPoint);
        mountPoint = this.trimTrailingSlashToKeepJettyHappy(mountPoint);
        NeoServletContainer container = new NeoServletContainer(this.server, this.server.getInjectables(packageNames));
        ServletHolder servletHolder = new ServletHolder((Servlet)container);
        if (!Boolean.valueOf(String.valueOf(this.server.getConfiguration().getProperty("unsupported_wadl_generation_enabled"))).booleanValue()) {
            servletHolder.setInitParameter("com.sun.jersey.config.feature.DisableWADL", String.valueOf(true));
        }
        servletHolder.setInitParameter("com.sun.jersey.config.property.packages", this.toCommaSeparatedList(packageNames));
        servletHolder.setInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", AllowAjaxFilter.class.getName());
        servletHolder.setInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", CollectUserAgentFilter.class.getName());
        log.debug("Adding JAXRS packages %s at [%s]", packageNames, mountPoint);
        this.jaxRSPackages.put(mountPoint, servletHolder);
    }

    @Override
    public void removeJAXRSPackages(List<String> packageNames, String serverMountPoint) {
        this.jaxRSPackages.remove(serverMountPoint);
    }

    @Override
    public void addFilter(Filter filter, String pathSpec) {
        this.filters.add(new FilterDefinition(filter, pathSpec));
    }

    @Override
    public void removeFilter(Filter filter, String pathSpec) {
        Iterator<FilterDefinition> iter = this.filters.iterator();
        while (iter.hasNext()) {
            FilterDefinition current = iter.next();
            if (!current.matches(filter, pathSpec)) continue;
            iter.remove();
        }
    }

    @Override
    public void setNeoServer(NeoServer server) {
        this.server = server;
    }

    @Override
    public void addStaticContent(String contentLocation, String serverMountPoint) {
        this.staticContent.put(serverMountPoint, contentLocation);
    }

    @Override
    public void removeStaticContent(String contentLocation, String serverMountPoint) {
        this.staticContent.remove(serverMountPoint);
    }

    @Override
    public void invokeDirectly(String targetPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.jetty.handle(targetPath, request, response, 1);
    }

    @Override
    public void setHttpLoggingConfiguration(File logbackConfigFile) {
        this.requestLoggingConfiguration = logbackConfigFile;
    }

    @Override
    public void setEnableHttps(boolean enable) {
        this.httpsEnabled = enable;
    }

    @Override
    public void setHttpsPort(int portNo) {
        this.jettyHttpsPort = portNo;
    }

    @Override
    public void setHttpsCertificateInformation(KeyStoreInformation config) {
        this.httpsCertificateInformation = config;
    }

    public Server getJetty() {
        return this.jetty;
    }

    protected void startJetty() {
        try {
            this.jetty.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int tenThreadsPerProcessor() {
        return 10 * Runtime.getRuntime().availableProcessors();
    }

    private void loadAllMounts() {
        HashSessionManager sm = new HashSessionManager();
        TreeSet<String> mountpoints = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        if (this.requestLoggingConfiguration != null) {
            this.loadRequestLogging();
        }
        mountpoints.addAll(this.staticContent.keySet());
        mountpoints.addAll(this.jaxRSPackages.keySet());
        for (String contentKey : mountpoints) {
            boolean isStatic = this.staticContent.containsKey(contentKey);
            boolean isJaxrs = this.jaxRSPackages.containsKey(contentKey);
            if (isStatic && isJaxrs) {
                throw new RuntimeException(String.format("content-key '%s' is mapped twice (static and jaxrs)", contentKey));
            }
            if (isStatic) {
                this.loadStaticContent((SessionManager)sm, contentKey);
                continue;
            }
            if (isJaxrs) {
                this.loadJAXRSPackage((SessionManager)sm, contentKey);
                continue;
            }
            throw new RuntimeException(String.format("content-key '%s' is not mapped", contentKey));
        }
    }

    private void loadRequestLogging() {
        RequestLogImpl requestLog = new RequestLogImpl();
        requestLog.setFileName(this.requestLoggingConfiguration.getAbsolutePath());
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        this.jetty.addHandler((Handler)requestLogHandler);
    }

    private String trimTrailingSlashToKeepJettyHappy(String mountPoint) {
        if (mountPoint.equals("/")) {
            return mountPoint;
        }
        if (mountPoint.endsWith("/")) {
            mountPoint = mountPoint.substring(0, mountPoint.length() - 1);
        }
        return mountPoint;
    }

    private String ensureRelativeUri(String mountPoint) {
        try {
            URI result = new URI(mountPoint);
            if (result.isAbsolute()) {
                return result.getPath();
            }
            return result.toString();
        }
        catch (URISyntaxException e) {
            log.debug("Unable to translate [%s] to a relative URI in ensureRelativeUri(String mountPoint)", mountPoint);
            return mountPoint;
        }
    }

    private void loadStaticContent(SessionManager sm, String mountPoint) {
        String contentLocation = this.staticContent.get(mountPoint);
        log.info("Mounting static content at [%s] from [%s]", mountPoint, contentLocation);
        try {
            WebAppContext staticContext = new WebAppContext(null, new SessionHandler(sm), null, null);
            staticContext.setServer(this.getJetty());
            staticContext.setContextPath(mountPoint);
            URL resourceLoc = this.getClass().getClassLoader().getResource(contentLocation);
            if (resourceLoc != null) {
                log.debug("Found [%s]", resourceLoc);
                URL url = resourceLoc.toURI().toURL();
                Resource resource = Resource.newResource((URL)url);
                staticContext.setBaseResource(resource);
                log.debug("Mounting static content from [%s] at [%s]", url, mountPoint);
                this.addFiltersTo((Context)staticContext);
                this.jetty.addHandler((Handler)staticContext);
            } else {
                log.error("No static content available for Neo Server at port [%d], management console may not be available.", this.jettyHttpPort);
            }
        }
        catch (Exception e) {
            log.error(e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void loadJAXRSPackage(SessionManager sm, String mountPoint) {
        ServletHolder servletHolder = this.jaxRSPackages.get(mountPoint);
        log.debug("Mounting servlet at [%s]", mountPoint);
        Context jerseyContext = new Context((HandlerContainer)this.jetty, mountPoint);
        SessionHandler sh = new SessionHandler(sm);
        jerseyContext.addServlet(servletHolder, "/*");
        jerseyContext.setSessionHandler(sh);
        this.addFiltersTo(jerseyContext);
    }

    private void addFiltersTo(Context context) {
        for (FilterDefinition filterDef : this.filters) {
            context.addFilter(new FilterHolder(filterDef.getFilter()), filterDef.getPathSpec(), 15);
        }
    }

    private String toCommaSeparatedList(List<String> packageNames) {
        StringBuilder sb = new StringBuilder();
        for (String str : packageNames) {
            sb.append(str);
            sb.append(", ");
        }
        String result = sb.toString();
        return result.substring(0, result.length() - 2);
    }

    @Override
    public void addSecurityRules(final SecurityRule ... rules) {
        this.jetty.addLifeCycleListener((LifeCycle.Listener)new JettyLifeCycleListenerAdapter(){

            @Override
            public void lifeCycleStarted(LifeCycle arg0) {
                for (Handler handler : Jetty6WebServer.this.jetty.getHandlers()) {
                    if (!(handler instanceof Context)) continue;
                    Context context = (Context)handler;
                    for (SecurityRule rule : rules) {
                        if (!new UriPathWildcardMatcher(rule.forUriPath()).matches(context.getContextPath())) continue;
                        SecurityFilter jettyFilter = new SecurityFilter(rule);
                        context.addFilter(new FilterHolder((Filter)jettyFilter), "/*", 15);
                        log.info("Security rule [%s] installed on server", rule.getClass().getCanonicalName());
                        System.out.println(String.format("Security rule [%s] installed on server", rule.getClass().getCanonicalName()));
                    }
                }
            }
        });
    }

    @Override
    public void addExecutionLimitFilter(final int timeout) {
        final Guard guard = this.server.getDatabase().getGraph().getGuard();
        if (guard == null) {
            throw new RuntimeException("unable to use guard, enable guard-insertion in neo4j.properties");
        }
        this.jetty.addLifeCycleListener((LifeCycle.Listener)new JettyLifeCycleListenerAdapter(){

            @Override
            public void lifeCycleStarted(LifeCycle arg0) {
                for (Handler handler : Jetty6WebServer.this.jetty.getHandlers()) {
                    if (!(handler instanceof Context)) continue;
                    Context context = (Context)handler;
                    GuardingRequestFilter jettyFilter = new GuardingRequestFilter(guard, timeout);
                    FilterHolder holder = new FilterHolder((Filter)jettyFilter);
                    context.addFilter(holder, "/*", 15);
                }
            }
        });
    }

    private static class FilterDefinition {
        private final Filter filter;
        private final String pathSpec;

        public FilterDefinition(Filter filter, String pathSpec) {
            this.filter = filter;
            this.pathSpec = pathSpec;
        }

        public boolean matches(Filter filter, String pathSpec) {
            return filter == this.filter && pathSpec.equals(this.pathSpec);
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String getPathSpec() {
            return this.pathSpec;
        }
    }
}

