/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HTTPLoggingPreparednessRule
implements StartupHealthCheckRule {
    private String failureMessage = "";

    @Override
    public boolean execute(Properties properties) {
        boolean enabled = new Boolean(String.valueOf(properties.getProperty("org.neo4j.server.http.log.enabled")));
        if (!enabled) {
            return true;
        }
        File logLocation = this.extractLogLocationFromConfig(String.valueOf(properties.get("org.neo4j.server.http.log.config")));
        if (logLocation != null) {
            return this.validateFileBasedLoggingConfig(logLocation);
        }
        return true;
    }

    private boolean validateFileBasedLoggingConfig(File logLocation) {
        try {
            FileUtils.forceMkdir((File)logLocation);
        }
        catch (IOException e) {
            this.failureMessage = String.format("HTTP log file [%s] does not exist", logLocation.getAbsolutePath());
            return false;
        }
        if (!logLocation.exists()) {
            this.failureMessage = String.format("HTTP log [%s] cannot be created", logLocation.getAbsolutePath());
            return false;
        }
        if (!logLocation.canWrite()) {
            this.failureMessage = String.format("HTTP log [%s] is not writable", logLocation.getAbsolutePath());
            return false;
        }
        return true;
    }

    private File extractLogLocationFromConfig(String configLocation) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            File file = new File(configLocation);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            Node node = doc.getElementsByTagName("file").item(0);
            return new File(node.getTextContent());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }
}

