/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.io.File;
import java.util.Properties;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class ConfigFileMustBePresentRule
implements StartupHealthCheckRule {
    private static final String EMPTY_STRING = "";
    private boolean passed = false;
    private boolean ran = false;
    private String failureMessage = "";

    @Override
    public boolean execute(Properties properties) {
        this.ran = true;
        String configFilename = properties.getProperty("org.neo4j.server.properties");
        if (configFilename == null) {
            this.failureMessage = String.format("Property [%s] has not been set.", "org.neo4j.server.properties");
            return false;
        }
        File configFile = new File(configFilename);
        if (!configFile.exists()) {
            this.failureMessage = String.format("No configuration file at [%s]", configFile.getAbsoluteFile());
            return false;
        }
        this.passed = true;
        return this.passed;
    }

    @Override
    public String getFailureMessage() {
        if (this.passed) {
            return EMPTY_STRING;
        }
        if (!this.ran) {
            return String.format("%s has not been run", this.getClass().getName());
        }
        return this.failureMessage;
    }
}

