/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.logging.JulAdapter;
import org.neo4j.server.logging.Logger;

public abstract class Bootstrapper {
    public static final Integer OK = 0;
    public static final Integer WEB_SERVER_STARTUP_ERROR_CODE = 1;
    public static final Integer GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    private static Logger log = Logger.getLogger(CommunityBootstrapper.class);
    protected NeoServer server;
    private Configurator configurator;

    public static void main(String[] args) {
        Bootstrapper bootstrapper = Bootstrapper.loadMostDerivedBootstrapper();
        Integer exit = bootstrapper.start(args);
        if (exit != 0) {
            System.exit(exit);
        }
    }

    public static Bootstrapper loadMostDerivedBootstrapper() {
        Bootstrapper winner = new CommunityBootstrapper();
        for (Bootstrapper candidate : Service.load(Bootstrapper.class)) {
            if (!candidate.isMoreDerivedThan(winner)) continue;
            winner = candidate;
        }
        return winner;
    }

    public void controlEvent(int arg) {
    }

    public Integer start() {
        return this.start(new String[0]);
    }

    public Integer start(String[] args) {
        try {
            this.checkCompatibility();
            this.configurator = this.createConfigurator();
            this.server = this.createNeoServer();
            this.server.start();
            this.addShutdownHook();
            return OK;
        }
        catch (TransactionFailureException tfe) {
            log.error(tfe);
            log.error(String.format("Failed to start Neo Server on port [%d], because ", this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474)) + (Object)((Object)tfe) + ". Another process may be using database location " + this.server.getDatabase().getLocation(), new Object[0]);
            return GRAPH_DATABASE_STARTUP_ERROR_CODE;
        }
        catch (Exception e) {
            log.error(e);
            log.error("Failed to start Neo Server on port [%s]", this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474));
            return WEB_SERVER_STARTUP_ERROR_CODE;
        }
    }

    private void checkCompatibility() {
        new JvmChecker((StringLogger)new JulAdapter(log), new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
    }

    protected abstract NeoServer createNeoServer();

    public void stop() {
        this.stop(0);
    }

    public int stop(int stopArg) {
        String location = "unknown location";
        try {
            if (this.server != null) {
                this.server.stop();
            }
            log.info("Successfully shutdown Neo Server on port [%d], database [%s]", this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474), location);
            return 0;
        }
        catch (Exception e) {
            log.error("Failed to cleanly shutdown Neo Server on port [%d], database [%s]. Reason [%s] ", this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474), location, e.getMessage());
            return 1;
        }
    }

    public NeoServer getServer() {
        return this.server;
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("Neo4j Server shutdown initiated by kill signal", new Object[0]);
                if (Bootstrapper.this.server != null) {
                    Bootstrapper.this.server.stop();
                }
            }
        });
    }

    protected Configurator createConfigurator() {
        File configFile = new File(System.getProperty("org.neo4j.server.properties", Configurator.DEFAULT_CONFIG_DIR));
        return new PropertyFileConfigurator(new Validator(new DatabaseLocationMustBeSpecifiedRule()), configFile);
    }

    protected boolean isMoreDerivedThan(Bootstrapper other) {
        return other.getClass().isAssignableFrom(this.getClass());
    }
}

