/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import javax.servlet.http.HttpSession;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.database.Database;
import org.neo4j.server.webadmin.console.CypherSession;
import org.neo4j.server.webadmin.console.GremlinSession;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.rest.SessionFactory;
import org.neo4j.server.webadmin.rest.ShellSession;

public class SessionFactoryImpl
implements SessionFactory {
    private HttpSession httpSession;

    public SessionFactoryImpl(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    @Override
    public ScriptSession createSession(String engineName, Database database) {
        if (engineName.equals("shell")) {
            return this.getOrInstantiateSession(database, "shellSession", SessionCreator.SHELL);
        }
        return this.getOrInstantiateSession(database, "consoleSession", SessionCreator.GREMLIN);
    }

    private ScriptSession getOrInstantiateSession(Database database, String key, SessionCreator creator) {
        Object session = this.httpSession.getAttribute(key);
        if (session == null) {
            session = creator.newSession(database);
            this.httpSession.setAttribute(key, session);
        }
        return (ScriptSession)session;
    }

    private static enum SessionCreator {
        GREMLIN{

            @Override
            ScriptSession newSession(Database database) {
                return new GremlinSession(database);
            }
        }
        ,
        CYPHER{

            @Override
            ScriptSession newSession(Database database) {
                return new CypherSession((GraphDatabaseService)database.graph);
            }
        }
        ,
        SHELL{

            @Override
            ScriptSession newSession(Database database) {
                return new ShellSession(database.graph);
            }
        };


        abstract ScriptSession newSession(Database var1);
    }
}

